/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.security.SecureRandom;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.PageUtil;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.bytes.internal.HeapBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.analytics.AnalyticsFacade;
import net.openhft.chronicle.core.announcer.Announcer;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.threads.CleaningThreadLocal;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.core.threads.OnDemandEventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.AppenderListener;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.CycleCalculator;
import net.openhft.chronicle.queue.DefaultCycleCalculator;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import net.openhft.chronicle.queue.impl.single.FileSystemDirectoryListing;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.NoOpCondition;
import net.openhft.chronicle.queue.impl.single.PrecreatedFiles;
import net.openhft.chronicle.queue.impl.single.ReferenceCountedCache;
import net.openhft.chronicle.queue.impl.single.SCQMeta;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.impl.single.StoreTailer;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListing;
import net.openhft.chronicle.queue.impl.single.TableDirectoryListingReadOnly;
import net.openhft.chronicle.queue.impl.single.TableStoreWriteLock;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.queue.internal.AnalyticsHolder;
import net.openhft.chronicle.threads.DiskSpaceMonitor;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueue
extends AbstractCloseable
implements RollingChronicleQueue {
    public static final String SUFFIX = ".cq4";
    public static final String DISCARD_FILE_SUFFIX = ".discard";
    public static final String QUEUE_METADATA_FILE = "metadata.cq4t";
    public static final String DISK_SPACE_CHECKER_NAME = "disk~space~checker";
    private static final boolean SHOULD_CHECK_CYCLE = Jvm.getBoolean("chronicle.queue.checkrollcycle");
    static final int WARN_SLOW_APPENDER_MS = Jvm.getInteger("chronicle.queue.warnSlowAppenderMs", 100);
    @NotNull
    protected final EventLoop eventLoop;
    @NotNull
    protected final TableStore<SCQMeta> metaStore;
    @NotNull
    protected final WireStorePool pool;
    protected final boolean doubleBuffer;
    final Supplier<TimingPauser> pauserSupplier;
    final long timeoutMS;
    @NotNull
    final File path;
    final String fileAbsolutePath;
    private final Map<BytesStore, LongValue> metaStoreMap = new ConcurrentHashMap<BytesStore, LongValue>();
    private final StoreSupplier storeSupplier;
    private final long epoch;
    private final boolean isBuffered;
    @NotNull
    private final WireType wireType;
    private final long blockSize;
    private final long overlapSize;
    @NotNull
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final long bufferCapacity;
    private final int indexSpacing;
    private final int indexCount;
    @NotNull
    private final TimeProvider time;
    @NotNull
    private final BiFunction<RollingChronicleQueue, Wire, SingleChronicleQueueStore> storeFactory;
    private final Set<Closeable> closers = Collections.newSetFromMap(new IdentityHashMap());
    private final boolean readOnly;
    @NotNull
    private final CycleCalculator cycleCalculator;
    @Nullable
    private final LongValue lastAcknowledgedIndexReplicated;
    @Nullable
    private final LongValue lastIndexReplicated;
    private final LongValue lastIndexMSynced;
    @NotNull
    private final DirectoryListing directoryListing;
    @NotNull
    private final WriteLock writeLock;
    private final boolean checkInterrupts;
    @NotNull
    private final RollingResourcesCache dateCache;
    private final WriteLock appendLock;
    private final StoreFileListener storeFileListener;
    @NotNull
    private final RollCycle rollCycle;
    private final int deltaCheckpointInterval;
    @Deprecated
    private final boolean useSparseFile;
    private final long sparseCapacity;
    final AppenderListener appenderListener;
    protected int sourceId;
    private int cycleFileRenamed = -1;
    @NotNull
    private Condition createAppenderCondition = NoOpCondition.INSTANCE;
    protected final ThreadLocal<ExcerptAppender> strongExcerptAppenderThreadLocal = CleaningThreadLocal.withCloseQuietly(this::createNewAppenderOnceConditionIsMet);
    private final long forceDirectoryListingRefreshIntervalMs;
    private final long[] chunkCount = new long[]{0L};
    private final SyncMode syncMode;

    protected SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        try {
            this.rollCycle = builder.rollCycle();
            this.cycleCalculator = this.cycleCalculator(builder.rollTimeZone());
            this.epoch = builder.epoch();
            this.dateCache = new RollingResourcesCache(this.rollCycle, this.epoch, this.textToFile(builder), this.fileToText());
            this.storeFileListener = builder.storeFileListener();
            this.storeSupplier = new StoreSupplier();
            this.pool = WireStorePool.withSupplier(this.storeSupplier, this.storeFileListener);
            this.isBuffered = BufferMode.Asynchronous == builder.writeBufferMode();
            this.path = builder.path();
            if (!builder.readOnly()) {
                this.path.mkdirs();
            }
            this.fileAbsolutePath = this.path.getAbsolutePath();
            this.wireType = builder.wireType();
            this.blockSize = builder.blockSize();
            this.overlapSize = SingleChronicleQueue.calcOverlapSize(this.blockSize);
            this.useSparseFile = builder.useSparseFiles();
            this.sparseCapacity = builder.sparseCapacity();
            this.eventLoop = builder.eventLoop();
            this.bufferCapacity = builder.bufferCapacity();
            this.onRingBufferStats = builder.onRingBufferStats();
            this.indexCount = builder.indexCount();
            this.indexSpacing = builder.indexSpacing();
            this.time = builder.timeProvider();
            this.pauserSupplier = builder.pauserSupplier();
            this.timeoutMS = (long)((double)builder.timeoutMS() * (1.0 + 0.2 * (double)new SecureRandom().nextFloat()));
            this.storeFactory = builder.storeFactory();
            this.checkInterrupts = builder.checkInterrupts();
            this.metaStore = builder.metaStore();
            this.doubleBuffer = builder.doubleBuffer();
            this.syncMode = builder.syncMode();
            if (this.metaStore.readOnly() && !builder.readOnly()) {
                Jvm.warn().on(this.getClass(), "Forcing queue to be readOnly file=" + this.path);
                builder.readOnly(this.metaStore.readOnly());
            }
            this.readOnly = builder.readOnly();
            this.appenderListener = builder.appenderListener();
            if (this.metaStore.readOnly()) {
                this.directoryListing = new FileSystemDirectoryListing(this.path, this.fileNameToCycleFunction());
            } else {
                this.directoryListing = this.readOnly ? new TableDirectoryListingReadOnly(this.metaStore) : new TableDirectoryListing(this.metaStore, this.path.toPath(), this.fileNameToCycleFunction());
                this.directoryListing.init();
            }
            this.directoryListing.refresh(true);
            this.writeLock = builder.writeLock();
            if (this.writeLock instanceof TableStoreWriteLock) {
                this.writeLock.forceUnlockIfProcessIsDead();
            }
            this.appendLock = builder.appendLock();
            if (this.readOnly) {
                this.lastIndexReplicated = null;
                this.lastAcknowledgedIndexReplicated = null;
                this.lastIndexMSynced = null;
            } else {
                this.lastIndexReplicated = this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("chronicle.lastIndexReplicated", -1L));
                this.lastAcknowledgedIndexReplicated = this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("chronicle.lastAcknowledgedIndexReplicated", -1L));
                this.lastIndexMSynced = this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("chronicle.lastIndexMSynced", -1L));
            }
            this.deltaCheckpointInterval = builder.deltaCheckpointInterval();
            this.forceDirectoryListingRefreshIntervalMs = builder.forceDirectoryListingRefreshIntervalMs();
            this.sourceId = builder.sourceId();
            Announcer.announce("net.openhft", "chronicle-queue", AnalyticsFacade.isEnabled() ? Collections.singletonMap("Analytics", "Chronicle Queue reports usage statistics. Learn more or turn off: https://github.com/OpenHFT/Chronicle-Queue/blob/ea/DISCLAIMER.adoc") : Collections.emptyMap());
            Map<String, String> additionalEventParameters = AnalyticsFacade.standardAdditionalProperties();
            additionalEventParameters.put("wire_type", this.wireType.toString());
            String rollCycleName = this.rollCycle.toString();
            if (!rollCycleName.startsWith("TEST")) {
                additionalEventParameters.put("roll_cycle", rollCycleName);
            }
            AnalyticsHolder.instance().sendEvent("started", additionalEventParameters);
            this.singleThreadedCheckDisabled(true);
        }
        catch (Throwable t) {
            this.close();
            throw Jvm.rethrow(t);
        }
    }

    private static long calcOverlapSize(long blockSize) {
        long overlapSize = blockSize < 65536L ? blockSize : (blockSize < 262144L ? 65536L : (blockSize < 0x100000000L ? blockSize / 4L : 0x40000000L));
        return overlapSize;
    }

    protected void createAppenderCondition(@NotNull Condition createAppenderCondition) {
        this.createAppenderCondition = createAppenderCondition;
    }

    protected CycleCalculator cycleCalculator(ZoneId zoneId) {
        return DefaultCycleCalculator.INSTANCE;
    }

    @NotNull
    private Function<String, File> textToFile(@NotNull SingleChronicleQueueBuilder builder) {
        return name -> new File(builder.path(), name + SUFFIX);
    }

    @NotNull
    private Function<File, String> fileToText() {
        return file -> {
            String name = file.getName();
            return name.substring(0, name.length() - SUFFIX.length());
        };
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public long lastAcknowledgedIndexReplicated() {
        return this.lastAcknowledgedIndexReplicated == null ? -1L : this.lastAcknowledgedIndexReplicated.getVolatileValue(-1L);
    }

    @Override
    public void lastAcknowledgedIndexReplicated(long newValue) {
        if (this.lastAcknowledgedIndexReplicated != null) {
            this.lastAcknowledgedIndexReplicated.setMaxValue(newValue);
        }
    }

    @Override
    public void refreshDirectoryListing() {
        this.throwExceptionIfClosed();
        this.directoryListing.refresh(true);
    }

    @Override
    public long lastIndexReplicated() {
        return this.lastIndexReplicated == null ? -1L : this.lastIndexReplicated.getVolatileValue(-1L);
    }

    @Override
    public void lastIndexReplicated(long indexReplicated) {
        if (this.lastIndexReplicated != null) {
            this.lastIndexReplicated.setMaxValue(indexReplicated);
        }
    }

    @Override
    public long lastIndexMSynced() {
        return this.lastIndexMSynced == null ? -1L : this.lastIndexMSynced.getVolatileValue(-1L);
    }

    @Override
    public void lastIndexMSynced(long lastIndexMSynced) {
        if (this.lastIndexMSynced != null) {
            this.lastIndexMSynced.setMaxValue(lastIndexMSynced);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File file() {
        return this.path;
    }

    @Override
    @NotNull
    public String fileAbsolutePath() {
        return this.fileAbsolutePath;
    }

    @Override
    @NotNull
    public String dumpLastHeader() {
        StringBuilder sb = new StringBuilder(256);
        try (SingleChronicleQueueStore wireStore = this.storeForCycle(this.lastCycle(), this.epoch, false, null);){
            sb.append(wireStore.dumpHeader());
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String dump() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.metaStore.dump(this.wireType));
        int max = this.lastCycle();
        for (int i = this.firstCycle(); i <= max; ++i) {
            try (SingleChronicleQueueStore commonStore = this.storeForCycle(i, this.epoch, false, null);){
                if (commonStore == null) continue;
                sb.append(commonStore.dump(this.wireType));
                continue;
            }
        }
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void dump(@NotNull Writer writer, long fromIndex, long toIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 62[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long chunkCount() {
        return this.chunkCount[0];
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    public int deltaCheckpointInterval() {
        return this.deltaCheckpointInterval;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @NotNull
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @NotNull
    protected ExcerptAppender createNewAppenderOnceConditionIsMet() {
        try {
            this.createAppenderCondition.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedRuntimeException("Interrupted waiting for condition to create appender", e);
        }
        return this.constructAppender();
    }

    @NotNull
    protected ExcerptAppender constructAppender() {
        WireStorePool newPool = WireStorePool.withSupplier(this.storeSupplier, this.storeFileListener);
        return new StoreAppender(this, newPool, this.checkInterrupts);
    }

    protected StoreFileListener storeFileListener() {
        return this.storeFileListener;
    }

    WireStoreSupplier storeSupplier() {
        return this.storeSupplier;
    }

    @Override
    @NotNull
    public ExcerptAppender acquireAppender() {
        this.throwExceptionIfClosed();
        if (this.readOnly) {
            throw new IllegalStateException("Can't append to a read-only chronicle");
        }
        ExcerptAppender res = this.strongExcerptAppenderThreadLocal.get();
        if (res.isClosing()) {
            res = this.createNewAppenderOnceConditionIsMet();
            this.strongExcerptAppenderThreadLocal.set(res);
        }
        return res;
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() {
        this.throwExceptionIfClosed();
        if (this.readOnly) {
            throw new IllegalStateException("Can't append to a read-only chronicle");
        }
        return this.createNewAppenderOnceConditionIsMet();
    }

    @NotNull
    WriteLock writeLock() {
        return this.writeLock;
    }

    public WriteLock appendLock() {
        return this.appendLock;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer(String id) {
        this.throwExceptionIfClosed();
        LongValue index = id == null ? null : this.indexForId(id);
        StoreTailer storeTailer = new StoreTailer(this, this.pool, index);
        this.directoryListing.refresh(true);
        storeTailer.singleThreadedCheckReset();
        return storeTailer;
    }

    @Override
    @NotNull
    public LongValue indexForId(@NotNull String id) {
        return this.metaStore.doWithExclusiveLock(ts -> ts.acquireValueFor("index." + id, 0L));
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() {
        this.throwExceptionIfClosed();
        return this.createTailer(null);
    }

    @Override
    @Nullable
    public final SingleChronicleQueueStore storeForCycle(int cycle, long epoch, boolean createIfAbsent, SingleChronicleQueueStore oldStore) {
        return this.pool.acquire(cycle, createIfAbsent ? WireStoreSupplier.CreateStrategy.CREATE : WireStoreSupplier.CreateStrategy.READ_ONLY, oldStore);
    }

    @Override
    public int nextCycle(int cycle, @NotNull TailerDirection direction) throws ParseException {
        this.throwExceptionIfClosed();
        return this.pool.nextCycle(cycle, direction);
    }

    @Deprecated
    public long approximateExcerptsInCycle(int cycle) {
        this.throwExceptionIfClosed();
        try (ExcerptTailer tailer = this.createTailer();){
            long l = tailer.approximateExcerptsInCycle(cycle);
            return l;
        }
    }

    @Deprecated
    public long exactExcerptsInCycle(int cycle) {
        this.throwExceptionIfClosed();
        try (ExcerptTailer tailer = this.createTailer();){
            long l = tailer.exactExcerptsInCycle(cycle);
            return l;
        }
    }

    @Override
    public long countExcerpts(long fromIndex, long toIndex) {
        NavigableSet<Long> cycles;
        int upperCycle;
        int lowerCycle;
        this.throwExceptionIfClosed();
        if (fromIndex > toIndex) {
            long temp = fromIndex;
            fromIndex = toIndex;
            toIndex = temp;
        }
        if (fromIndex == toIndex) {
            return 0L;
        }
        long result = 0L;
        RollCycle rollCycle = this.rollCycle();
        long sequenceNotSet = rollCycle.toSequenceNumber(-1L);
        if (rollCycle.toSequenceNumber(fromIndex) == sequenceNotSet) {
            ++result;
            ++fromIndex;
        }
        if (rollCycle.toSequenceNumber(toIndex) == sequenceNotSet) {
            --result;
            ++toIndex;
        }
        if ((lowerCycle = rollCycle.toCycle(fromIndex)) == (upperCycle = rollCycle.toCycle(toIndex))) {
            return toIndex - fromIndex;
        }
        long upperSeqNum = rollCycle.toSequenceNumber(toIndex);
        long lowerSeqNum = rollCycle.toSequenceNumber(fromIndex);
        if (lowerCycle + 1 == upperCycle) {
            long l = this.exactExcerptsInCycle(lowerCycle);
            return result += l - lowerSeqNum + upperSeqNum;
        }
        try {
            cycles = this.listCyclesBetween(lowerCycle, upperCycle);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if ((Long)cycles.first() == (long)lowerCycle) {
            long l = this.exactExcerptsInCycle(lowerCycle);
            result += l - lowerSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found, lower-cycle=" + Long.toHexString(lowerCycle));
        }
        if ((Long)cycles.last() == (long)upperCycle) {
            result += upperSeqNum;
        } else {
            throw new IllegalStateException("Cycle not found,  upper-cycle=" + Long.toHexString(upperCycle));
        }
        if (cycles.size() == 2) {
            return result;
        }
        long[] array = cycles.stream().mapToLong(i -> i).toArray();
        for (int i2 = 1; i2 < array.length - 1; ++i2) {
            long x = this.exactExcerptsInCycle(Math.toIntExact(array[i2]));
            result += x;
        }
        return result;
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        this.throwExceptionIfClosed();
        return this.pool.listCyclesBetween(lowerCycle, upperCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addCloseListener(Closeable key) {
        Set<Closeable> set = this.closers;
        synchronized (set) {
            if (!this.closers.isEmpty()) {
                this.closers.removeIf(QueryCloseable::isClosed);
            }
            this.closers.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performClose() {
        Set<Closeable> set = this.closers;
        synchronized (set) {
            this.metaStoreMap.values().forEach(Closeable::closeQuietly);
            this.metaStoreMap.clear();
            this.closers.forEach(Closeable::closeQuietly);
            this.closers.clear();
            Closeable.closeQuietly(this.createAppenderCondition, this.directoryListing, this.lastAcknowledgedIndexReplicated, this.lastIndexReplicated, this.lastIndexMSynced, this.writeLock, this.appendLock, this.pool, this.metaStore);
            Closeable.closeQuietly((Object)this.storeSupplier);
        }
        if (this.eventLoop instanceof OnDemandEventLoop) {
            this.eventLoop.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.warnAndCloseIfNotClosed();
    }

    public final void closeStore(@Nullable SingleChronicleQueueStore store) {
        if (store != null) {
            this.pool.closeStore(store);
        }
    }

    @Override
    public final int cycle() {
        return this.cycleCalculator.currentCycle(this.rollCycle, this.time, this.epoch);
    }

    public final int cycle(TimeProvider timeProvider) {
        return this.cycleCalculator.currentCycle(this.rollCycle, timeProvider, this.epoch);
    }

    @Override
    public long firstIndex() {
        int cycle = this.firstCycle();
        if (cycle == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.rollCycle().toIndex(cycle, 0L);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long lastIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long entryCount() {
        try (ExcerptTailer tailer = this.createTailer();){
            tailer.toEnd();
            long lastIndex = tailer.index();
            if (lastIndex == 0L) {
                long l = 0L;
                return l;
            }
            long l = this.countExcerpts(this.firstIndex(), lastIndex);
            return l;
        }
    }

    @Nullable
    String[] getList() {
        return this.path.list();
    }

    private void setFirstAndLastCycle() {
        long now = System.currentTimeMillis();
        if (now <= this.directoryListing.lastRefreshTimeMS()) {
            return;
        }
        boolean force = now - this.directoryListing.lastRefreshTimeMS() > this.forceDirectoryListingRefreshIntervalMs;
        this.directoryListing.refresh(force);
    }

    @Override
    public int firstCycle() {
        this.setFirstAndLastCycle();
        return this.directoryListing.getMinCreatedCycle();
    }

    void onRoll(int cycle) {
        this.directoryListing.onRoll(cycle);
    }

    @Override
    public int lastCycle() {
        this.setFirstAndLastCycle();
        return this.directoryListing.getMaxCreatedCycle();
    }

    @NotNull
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public long overlapSize() {
        return this.overlapSize;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    @NotNull
    MappedFile mappedFile(File file) throws FileNotFoundException {
        long chunkSize = OS.pageAlign(this.blockSize);
        int pageSize = PageUtil.getPageSize(file.getAbsolutePath());
        MappedFile mappedFile = this.useSparseFile ? MappedFile.ofSingle(file, this.sparseCapacity, this.readOnly) : MappedFile.of(file, chunkSize, this.overlapSize, pageSize, this.readOnly);
        mappedFile.syncMode(this.syncMode);
        return mappedFile;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{sourceId=" + this.sourceId + ", file=" + this.path + '}';
    }

    @Override
    @NotNull
    public TimeProvider time() {
        return this.time;
    }

    @NotNull
    private ToIntFunction<String> fileNameToCycleFunction() {
        return name -> this.dateCache.parseCount(name.substring(0, name.length() - SUFFIX.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCloseListener(StoreTailer storeTailer) {
        Set<Closeable> set = this.closers;
        synchronized (set) {
            this.closers.remove(storeTailer);
        }
    }

    public TableStore metaStore() {
        return this.metaStore;
    }

    public void tableStorePut(CharSequence key, long index) {
        LongValue longValue = this.tableStoreAcquire(key, index);
        if (longValue == null) {
            return;
        }
        if (index == Long.MIN_VALUE) {
            longValue.setVolatileValue(index);
        } else {
            longValue.setMaxValue(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected LongValue tableStoreAcquire(CharSequence key, long defaultValue) {
        try (ScopedResource<Bytes<?>> bytesTl = Wires.acquireBytesScoped();){
            Object object;
            BytesStore keyBytes = this.asBytes(key, bytesTl.get());
            LongValue longValue = this.metaStoreMap.get(keyBytes);
            if (longValue == null) {
                object = this.closers;
                synchronized (object) {
                    longValue = this.metaStoreMap.get(keyBytes);
                    if (longValue == null) {
                        longValue = this.metaStore.acquireValueFor(key, defaultValue);
                        int length = key.length();
                        HeapBytesStore<byte[]> key2 = HeapBytesStore.wrap(new byte[length]);
                        key2.write(0L, keyBytes, 0L, (long)length);
                        this.metaStoreMap.put(key2, longValue);
                        LongValue longValue2 = longValue;
                        return longValue2;
                    }
                }
            }
            object = longValue;
            return object;
        }
    }

    public long tableStoreGet(CharSequence key) {
        LongValue longValue = this.tableStoreAcquire(key, Long.MIN_VALUE);
        if (longValue == null) {
            return Long.MIN_VALUE;
        }
        return longValue.getVolatileValue();
    }

    private BytesStore asBytes(CharSequence key, Bytes<?> bytes) {
        return key instanceof BytesStore ? (BytesStore)key : (BytesStore)((Object)bytes.append(key));
    }

    class StoreSupplier
    extends AbstractCloseable
    implements WireStoreSupplier {
        private final AtomicReference<CachedCycleTree> cachedTree = new AtomicReference();
        private final ReferenceCountedCache<File, MappedFile, MappedBytes, IOException> mappedFileCache = new ReferenceCountedCache(MappedBytes::mappedBytes, this$0::mappedFile);
        private boolean queuePathExists;

        private StoreSupplier() {
            this.singleThreadedCheckDisabled(true);
        }

        @Override
        public SingleChronicleQueueStore acquire(int cycle, WireStoreSupplier.CreateStrategy createStrategy) {
            this.throwExceptionIfClosed();
            SingleChronicleQueue that = SingleChronicleQueue.this;
            @NotNull RollingResourcesCache.Resource dateValue = that.dateCache.resourceFor(cycle);
            MappedBytes mappedBytes = null;
            try {
                SingleChronicleQueueStore wireStore;
                block31: {
                    File path = dateValue.path;
                    SingleChronicleQueue.this.directoryListing.refresh(false);
                    if (!(createStrategy == WireStoreSupplier.CreateStrategy.CREATE || cycle <= SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() && cycle >= SingleChronicleQueue.this.directoryListing.getMinCreatedCycle() && path.exists())) {
                        return null;
                    }
                    if (createStrategy != WireStoreSupplier.CreateStrategy.READ_ONLY) {
                        this.checkDiskSpace(that.path);
                    }
                    this.throwExceptionIfClosed();
                    if (createStrategy == WireStoreSupplier.CreateStrategy.CREATE && !path.exists() && !dateValue.pathExists) {
                        PrecreatedFiles.renamePreCreatedFileToRequiredFile(path);
                    }
                    dateValue.pathExists = true;
                    try {
                        mappedBytes = this.mappedFileCache.get(path);
                    }
                    catch (FileNotFoundException e) {
                        this.createFile(path);
                        mappedBytes = this.mappedFileCache.get(path);
                    }
                    mappedBytes.singleThreadedCheckDisabled(true);
                    mappedBytes.chunkCount(SingleChronicleQueue.this.chunkCount);
                    if (SHOULD_CHECK_CYCLE && cycle != SingleChronicleQueue.this.rollCycle.current(SingleChronicleQueue.this.time, SingleChronicleQueue.this.epoch)) {
                        Jvm.warn().on(this.getClass(), new Exception("Creating cycle which is not the current cycle"));
                    }
                    this.queuePathExists = true;
                    AbstractWire wire = (AbstractWire)SingleChronicleQueue.this.wireType.apply(mappedBytes);
                    wire.pauser(SingleChronicleQueue.this.pauserSupplier.get());
                    wire.headerNumber(SingleChronicleQueue.this.rollCycle.toIndex(cycle, 0L));
                    try {
                        if (!SingleChronicleQueue.this.readOnly && createStrategy == WireStoreSupplier.CreateStrategy.CREATE && wire.writeFirstHeader()) {
                            wireStore = (SingleChronicleQueueStore)SingleChronicleQueue.this.storeFactory.apply(that, wire);
                            this.createIndexThenUpdateHeader(wire, cycle, wireStore);
                            break block31;
                        }
                        try {
                            wire.readFirstHeader(SingleChronicleQueue.this.timeoutMS, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            File cycleFile = mappedBytes.mappedFile().file();
                            mappedBytes.close();
                            this.mappedFileCache.remove(path);
                            if (!SingleChronicleQueue.this.readOnly && createStrategy != WireStoreSupplier.CreateStrategy.READ_ONLY && SingleChronicleQueue.this.cycleFileRenamed != cycle) {
                                SingleChronicleQueueStore acquired = this.acquire(cycle, this.backupCycleFile(cycle, cycleFile));
                                if (acquired == null) {
                                    throw e;
                                }
                                return acquired;
                            }
                            if (Jvm.debug().isEnabled(SingleChronicleQueue.class)) {
                                Jvm.debug().on(SingleChronicleQueue.class, "Cycle file not ready: " + cycleFile.getAbsolutePath());
                            }
                            return null;
                        }
                        ValueIn valueIn = this.readWireStoreValue(wire);
                        try {
                            wireStore = (SingleChronicleQueueStore)valueIn.typedMarshallable();
                        }
                        catch (Throwable t) {
                            mappedBytes.close();
                            throw t;
                        }
                    }
                    catch (InternalError e) {
                        long pos = Objects.requireNonNull(mappedBytes.bytesStore()).addressForRead(0L);
                        String s = Long.toHexString(pos);
                        System.err.println("pos=" + s);
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/self/maps")));){
                            String line;
                            while ((line = br.readLine()) != null) {
                                if (!line.contains(SingleChronicleQueue.SUFFIX)) continue;
                                System.err.println(line);
                            }
                        }
                        throw e;
                    }
                }
                return wireStore;
            }
            catch (IOException | TimeoutException e) {
                Closeable.closeQuietly(mappedBytes);
                throw Jvm.rethrow(e);
            }
        }

        @NotNull
        private ValueIn readWireStoreValue(@NotNull Wire wire) throws StreamCorruptedException {
            try (ScopedResource<StringBuilder> stlSb = Wires.acquireStringBuilderScoped();){
                StringBuilder name = stlSb.get();
                ValueIn valueIn = wire.readEventName(name);
                if (!StringUtils.isEqual(name, MetaDataKeys.header.name())) {
                    throw new StreamCorruptedException("The first message should be the header, was " + name);
                }
                ValueIn valueIn2 = valueIn;
                return valueIn2;
            }
        }

        private WireStoreSupplier.CreateStrategy backupCycleFile(int cycle, File cycleFile) {
            File cycleFileDiscard = new File(cycleFile.getParentFile(), String.format("%s-%d%s", cycleFile.getName(), System.currentTimeMillis(), SingleChronicleQueue.DISCARD_FILE_SUFFIX));
            boolean success = cycleFile.renameTo(cycleFileDiscard);
            if (success) {
                SingleChronicleQueue.this.cycleFileRenamed = cycle;
            }
            Jvm.warn().on(SingleChronicleQueue.class, "Renamed un-acquirable segment file to " + cycleFileDiscard.getAbsolutePath() + ": " + success);
            return success ? WireStoreSupplier.CreateStrategy.CREATE : WireStoreSupplier.CreateStrategy.READ_ONLY;
        }

        private void createIndexThenUpdateHeader(AbstractWire wire, int cycle, SingleChronicleQueueStore wireStore) {
            wire.usePadding(wireStore.dataVersion() > 0);
            wire.padToCacheAlign();
            long headerEndPos = wire.bytes().writePosition();
            wireStore.initIndex(wire);
            wire.updateFirstHeader(headerEndPos);
            wire.bytes().writePosition(4L);
            SingleChronicleQueue.this.directoryListing.onFileCreated(SingleChronicleQueue.this.path, cycle);
        }

        @Override
        protected void performClose() {
            this.mappedFileCache.close();
        }

        private void createFile(File path) {
            try {
                File dir = path.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!path.createNewFile()) {
                    Jvm.warn().on(this.getClass(), "unable to create a file at " + path.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                Jvm.warn().on(this.getClass(), "unable to create a file at " + path.getAbsolutePath(), (Throwable)ex);
            }
        }

        private void checkDiskSpace(@NotNull File filePath) {
            DiskSpaceMonitor.INSTANCE.pollDiskSpace(filePath);
        }

        @NotNull
        private NavigableMap<Long, File> cycleTree(boolean force) {
            File parentFile = SingleChronicleQueue.this.path;
            if (!this.queuePathExists && !parentFile.exists()) {
                throw new IllegalStateException("parentFile=" + parentFile.getName() + " does not exist");
            }
            CachedCycleTree cachedValue = this.cachedTree.get();
            long directoryModCount = SingleChronicleQueue.this.directoryListing.modCount();
            if (force || cachedValue == null || directoryModCount == -1L || directoryModCount > cachedValue.directoryModCount) {
                CachedCycleTree existing;
                RollingResourcesCache dateCache = SingleChronicleQueue.this.dateCache;
                TreeMap<Long, File> tree = new TreeMap<Long, File>();
                File[] files = parentFile.listFiles(file -> file.getPath().endsWith(SingleChronicleQueue.SUFFIX));
                if (files != null) {
                    for (File file2 : files) {
                        tree.put(dateCache.toLong(file2), file2);
                    }
                }
                cachedValue = new CachedCycleTree(directoryModCount, tree);
                while (!((existing = this.cachedTree.get()) != null && existing.directoryModCount > cachedValue.directoryModCount || this.cachedTree.compareAndSet(existing, cachedValue))) {
                    Jvm.nanoPause();
                }
            }
            return cachedValue.cachedCycleTree;
        }

        @Override
        public int nextCycle(int currentCycle, @NotNull TailerDirection direction) {
            Long key;
            File file;
            this.throwExceptionIfClosed();
            if (direction == TailerDirection.NONE) {
                throw new AssertionError((Object)"direction is NONE");
            }
            assert (currentCycle >= 0) : "currentCycle=" + Integer.toHexString(currentCycle);
            NavigableMap<Long, File> tree = this.cycleTree(false);
            File currentCycleFile = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)currentCycle)).path;
            SingleChronicleQueue.this.directoryListing.refresh(false);
            if (currentCycle > SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() || currentCycle < SingleChronicleQueue.this.directoryListing.getMinCreatedCycle()) {
                for (int i = 0; i < 20; ++i) {
                    Jvm.pause(10L);
                    SingleChronicleQueue.this.directoryListing.refresh(i > 1);
                    if (currentCycle <= SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle() && currentCycle >= SingleChronicleQueue.this.directoryListing.getMinCreatedCycle()) break;
                }
            }
            if ((file = (File)tree.get(key = SingleChronicleQueue.this.dateCache.toLong(currentCycleFile))) == null) {
                tree = this.cycleTree(true);
                file = (File)tree.get(key);
            }
            if (file == null) {
                Jvm.error().on(SingleChronicleQueue.class, "The current cycle seems to have been deleted from under the queue, scanning to find the next remaining cycle, currentCycle=" + currentCycleFile);
            }
            switch (direction) {
                case FORWARD: {
                    return this.toCycle(tree.higherEntry(key));
                }
                case BACKWARD: {
                    return this.toCycle(tree.lowerEntry(key));
                }
            }
            throw new UnsupportedOperationException("Unsupported Direction");
        }

        private int toCycle(@Nullable Map.Entry<Long, File> entry) {
            if (entry == null || entry.getValue() == null) {
                return -1;
            }
            return SingleChronicleQueue.this.dateCache.parseCount((String)SingleChronicleQueue.this.fileToText().apply(entry.getValue()));
        }

        @Override
        public NavigableSet<Long> cycles(int lowerCycle, int upperCycle) {
            this.throwExceptionIfClosed();
            NavigableMap<Long, File> tree = this.cycleTree(false);
            Long lowerKey = this.toKey(lowerCycle, "lowerCycle");
            Long upperKey = this.toKey(upperCycle, "upperCycle");
            assert (lowerKey != null);
            assert (upperKey != null);
            return tree.subMap(lowerKey, true, upperKey, true).navigableKeySet();
        }

        @Override
        public boolean canBeReused(@NotNull SingleChronicleQueueStore store) {
            SingleChronicleQueue.this.setFirstAndLastCycle();
            int cycle = store.cycle();
            return !store.isClosed() && cycle >= SingleChronicleQueue.this.directoryListing.getMinCreatedCycle() && cycle <= SingleChronicleQueue.this.directoryListing.getMaxCreatedCycle();
        }

        private Long toKey(int cyle, String m) {
            File file = ((SingleChronicleQueue)SingleChronicleQueue.this).dateCache.resourceFor((long)((long)cyle)).path;
            if (!file.exists()) {
                throw new IllegalStateException("'file not found' for the " + m + ", file=" + file);
            }
            return SingleChronicleQueue.this.dateCache.toLong(file);
        }
    }

    private static final class CachedCycleTree {
        private final long directoryModCount;
        private final NavigableMap<Long, File> cachedCycleTree;

        CachedCycleTree(long directoryModCount, NavigableMap<Long, File> cachedCycleTree) {
            this.directoryModCount = directoryModCount;
            this.cachedCycleTree = cachedCycleTree;
        }
    }
}

