/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingInputStream;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.core.util.ThrowingConsumerNonCapturing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataInput<S extends StreamingDataInput<S>>
extends StreamingCommon<S> {
    @NotNull
    public S readPosition(@NonNegative long var1) throws BufferUnderflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @NotNull
    default public S readPositionUnlimited(@NonNegative long position) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readLimitToCapacity().readPosition(position);
    }

    @NotNull
    default public S readPositionRemaining(@NonNegative long position, @NonNegative long remaining) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readLimit(position + remaining);
        return this.readPosition(position);
    }

    @NotNull
    public S readLimit(@NonNegative long var1) throws BufferUnderflowException, ThreadingIllegalStateException;

    default public S readLimitToCapacity() throws BufferUnderflowException, ThreadingIllegalStateException {
        return this.readLimit(this.capacity());
    }

    @NotNull
    public S readSkip(long var1) throws BufferUnderflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public long readPositionForHeader(boolean skipPadding) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        long position = this.readPosition();
        if (skipPadding) {
            return this.readSkip(BytesUtil.padOffset(position)).readPosition();
        }
        return position;
    }

    public void uncheckedReadSkipOne();

    public void uncheckedReadSkipBackOne();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength0(@NonNegative long length, @NotNull ThrowingConsumerNonCapturing<S, IORuntimeException, BytesOut> bytesConsumer, StringBuilder sb, BytesOut<?> toBytes) throws BufferUnderflowException, IORuntimeException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(bytesConsumer);
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            bytesConsumer.accept(this, sb, toBytes);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(@NonNegative long length, @NotNull ThrowingConsumer<S, IORuntimeException> bytesConsumer) throws BufferUnderflowException, IORuntimeException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(bytesConsumer);
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            bytesConsumer.accept(this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    @NotNull
    default public InputStream inputStream() {
        return new StreamingInputStream(this);
    }

    default public long readStopBit() throws IORuntimeException, ClosedIllegalStateException, BufferUnderflowException {
        return BytesInternal.readStopBit(this);
    }

    default public char readStopBitChar() throws IORuntimeException, ClosedIllegalStateException, BufferUnderflowException {
        return BytesInternal.readStopBitChar(this);
    }

    default public double readStopBitDouble() throws ClosedIllegalStateException {
        return BytesInternal.readStopBitDouble(this);
    }

    default public double readStopBitDecimal() throws ClosedIllegalStateException, BufferUnderflowException {
        long value = this.readStopBit();
        int scale = (int)(Math.abs(value) % 10L);
        return (double)(value /= 10L) / (double)Maths.tens(scale);
    }

    default public boolean readBoolean() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        byte b = this.readByte();
        return BytesUtil.byteToBoolean(b);
    }

    public byte readByte() throws ClosedIllegalStateException, ThreadingIllegalStateException;

    default public byte rawReadByte() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readByte();
    }

    default public char readChar() throws ClosedIllegalStateException, BufferUnderflowException {
        return this.readStopBitChar();
    }

    public int readUnsignedByte() throws ClosedIllegalStateException, ThreadingIllegalStateException;

    public int uncheckedReadUnsignedByte();

    public short readShort() throws BufferUnderflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public int readUnsignedShort() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readShort() & 0xFFFF;
    }

    default public int readInt24() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readUnsignedShort() | this.readUnsignedByte() << 24 >> 8;
    }

    default public int readUnsignedInt24() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readUnsignedShort() | this.readUnsignedByte() << 16;
    }

    public int readInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public int rawReadInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readInt();
    }

    default public long readUnsignedInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    default public long rawReadLong() throws BufferUnderflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.readLong();
    }

    default public long readIncompleteLong() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        long left = this.readRemaining();
        if (left >= 8L) {
            return this.readLong();
        }
        if (left == 4L) {
            return this.readInt();
        }
        long l = 0L;
        int remaining = (int)left;
        for (int i = 0; i < remaining; ++i) {
            l |= (long)this.readUnsignedByte() << i * 8;
        }
        return l;
    }

    public float readFloat() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public double readDouble() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    @Nullable
    default public String readUtf8() throws BufferUnderflowException, IORuntimeException, ClosedIllegalStateException, ArithmeticException {
        return BytesInternal.readUtf8(this);
    }

    @Nullable
    default public String read8bit() throws IORuntimeException, BufferUnderflowException, ClosedIllegalStateException, ArithmeticException {
        return BytesInternal.read8bit(this);
    }

    default public <C extends Appendable & CharSequence> boolean readUtf8(@NotNull C sb) throws IORuntimeException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, IllegalArgumentException {
        AppendableUtil.setLength(sb, 0);
        if (this.readRemaining() <= 0L) {
            return true;
        }
        long len0 = this.readStopBit();
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31(len0);
        if (len > 0) {
            BytesInternal.parseUtf8(this, sb, true, len);
        }
        return true;
    }

    default public boolean readUtf8(@NotNull Bytes<?> sb) throws IORuntimeException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, ThreadingIllegalStateException {
        sb.readPositionRemaining(0L, 0L);
        if (this.readRemaining() <= 0L) {
            return true;
        }
        long len0 = this.readStopBit();
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31(len0);
        if (len > 0) {
            BytesInternal.parseUtf8(this, sb, true, len);
        }
        return true;
    }

    default public boolean readUtf8(@NotNull StringBuilder sb) throws IORuntimeException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException {
        sb.setLength(0);
        if (this.readRemaining() <= 0L) {
            return true;
        }
        long len0 = this.readStopBit();
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31(len0);
        if (len > 0) {
            BytesInternal.parseUtf8(this, sb, true, len);
        }
        return true;
    }

    default public boolean read8bit(@NotNull Bytes<?> b) throws BufferUnderflowException, ClosedIllegalStateException, ArithmeticException, BufferOverflowException, ThreadingIllegalStateException {
        long len0;
        b.clear();
        if (this.readRemaining() <= 0L) {
            return true;
        }
        byte b1 = this.rawReadByte();
        if (b1 >= 0) {
            len0 = b1;
        } else {
            if (b1 == -128 && this.peekUnsignedByte() == 0) {
                this.readSkip(1L);
                return false;
            }
            len0 = BytesInternal.readStopBit0(this, b1);
        }
        int len = Maths.toUInt31(len0);
        b.write((BytesStore)((Object)this), this.readPosition(), (long)len);
        this.readSkip(len);
        return true;
    }

    default public boolean read8bit(@NotNull StringBuilder sb) throws IORuntimeException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException {
        sb.setLength(0);
        if (this.readRemaining() <= 0L) {
            return true;
        }
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31(len0);
        try {
            AppendableUtil.parse8bit(this, sb, len);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    default public int read(byte[] bytes) throws BufferUnderflowException, IllegalStateException, ClosedIllegalStateException, ThreadingIllegalStateException {
        return this.read(bytes, 0, bytes.length);
    }

    default public int read(byte[] bytes, @NonNegative int off, @NonNegative int len) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int i;
        ObjectUtils.requireNonNull(bytes);
        long remaining = this.readRemaining();
        if (remaining <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, remaining);
        for (i = 0; i < len2 - 7; i += 8) {
            UnsafeMemory.unsafePutLong(bytes, i + off, this.rawReadLong());
        }
        while (i < len2) {
            bytes[off + i] = this.rawReadByte();
            ++i;
        }
        return len2;
    }

    default public int read(char[] bytes, @NonNegative int off, @NonNegative int len) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        long remaining = this.readRemaining();
        if (remaining <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, remaining);
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = (char)this.readUnsignedByte();
        }
        return len2;
    }

    default public void read(@NotNull ByteBuffer buffer) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(buffer);
        for (int i = (int)Math.min(this.readRemaining(), (long)buffer.remaining()); i > 0; --i) {
            buffer.put(this.readByte());
        }
    }

    default public void read(@NotNull Bytes<?> bytes) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        int length = Math.toIntExact(Math.min(this.readRemaining(), bytes.writeRemaining()));
        this.read(bytes, length);
    }

    default public void read(@NotNull Bytes<?> bytes, @NonNegative int length) throws BufferUnderflowException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int i;
        ObjectUtils.requireNonNull(bytes);
        int len2 = (int)Math.min((long)length, this.readRemaining());
        for (i = 0; i < len2 - 7; i += 8) {
            bytes.rawWriteLong(this.rawReadLong());
        }
        while (i < len2) {
            bytes.rawWriteByte(this.rawReadByte());
            ++i;
        }
    }

    default public void unsafeReadObject(@NotNull Object o, @NonNegative int length) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.unsafeReadObject(o, (o.getClass().isArray() ? 4 : 0) + Jvm.objectHeaderSize(), length);
    }

    default public void unsafeReadObject(@NotNull Object o, @NonNegative int offset, @NonNegative int length) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int i;
        ObjectUtils.requireNonNull(o);
        if (!1.$assertionsDisabled && !BytesUtil.isTriviallyCopyable(o.getClass(), offset, length)) {
            throw new AssertionError();
        }
        if (this.readRemaining() < (long)length) {
            throw new BufferUnderflowException();
        }
        if (this.isDirectMemory()) {
            long src = this.addressForRead(this.readPosition());
            this.readSkip(length);
            UnsafeMemory.MEMORY.copyMemory(src, o, (long)offset, length);
            return;
        }
        for (i = 0; i < length - 7; i += 8) {
            UnsafeMemory.unsafePutLong(o, (long)offset + (long)i, this.rawReadLong());
        }
        if (i < length - 3) {
            UnsafeMemory.unsafePutInt(o, (long)offset + (long)i, this.rawReadInt());
            i += 4;
        }
        while (i < length) {
            UnsafeMemory.unsafePutByte(o, (long)offset + (long)i, this.rawReadByte());
            ++i;
        }
    }

    default public S unsafeRead(long address, @NonNegative int length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        if (this.isDirectMemory()) {
            long src = this.addressForRead(this.readPosition());
            this.readSkip(length);
            UnsafeMemory.copyMemory(src, address, length);
        } else {
            int i;
            for (i = 0; i < length - 7; i += 8) {
                UnsafeMemory.MEMORY.writeLong(address + (long)i, this.readLong());
            }
            while (i < length) {
                UnsafeMemory.MEMORY.writeByte(address + (long)i, this.readByte());
                ++i;
            }
        }
        return (S)this;
    }

    public int readVolatileInt() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public long readVolatileLong() throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException;

    public int peekUnsignedByte() throws ClosedIllegalStateException, ThreadingIllegalStateException;

    @NotNull
    default public <E extends Enum<E>> E readEnum(@NotNull Class<E> eClass) throws IORuntimeException, BufferUnderflowException, ArithmeticException, ClosedIllegalStateException, BufferOverflowException {
        return BytesInternal.readEnum(this, eClass);
    }

    default public void parseUtf8(@NotNull Appendable sb, @NonNegative int encodedLength) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException, ClosedIllegalStateException {
        this.parseUtf8(sb, true, encodedLength);
    }

    default public void parseUtf8(@NotNull Appendable sb, boolean utf, @NonNegative int length) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException, ClosedIllegalStateException {
        AppendableUtil.setLength(sb, 0);
        BytesInternal.parseUtf8(this, sb, utf, length);
    }

    default public long parseHexLong() throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.parseHexLong(this);
    }

    public void copyTo(@NotNull OutputStream var1) throws IOException, ClosedIllegalStateException;

    public long copyTo(@NotNull BytesStore var1) throws ClosedIllegalStateException;

    default public void readHistogram(@NotNull Histogram histogram) throws BufferUnderflowException, IllegalStateException, ArithmeticException, ClosedIllegalStateException {
        BytesInternal.readHistogram(this, histogram);
    }

    default public void readWithLength(@NotNull Bytes<?> bytes) throws ArithmeticException, BufferUnderflowException, BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int i;
        bytes.clear();
        int length = Maths.toUInt31(this.readStopBit());
        for (i = 0; i < length - 7; i += 8) {
            bytes.writeLong(this.readLong());
        }
        while (i < length) {
            bytes.writeByte(this.readByte());
            ++i;
        }
    }

    public void lenient(boolean var1);

    public boolean lenient();

    @NotNull
    default public BigDecimal readBigDecimal() throws ArithmeticException, BufferUnderflowException, IllegalStateException, ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        return new BigDecimal(this.readBigInteger(), Maths.toUInt31(this.readStopBit()));
    }

    @NotNull
    default public BigInteger readBigInteger() throws ArithmeticException, BufferUnderflowException, ClosedIllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        int length = Maths.toUInt31(this.readStopBit());
        if (length == 0) {
            if (this.lenient()) {
                return BigInteger.ZERO;
            }
            throw new BufferUnderflowException();
        }
        byte[] bytes = new byte[length];
        this.read(bytes);
        return new BigInteger(bytes);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

