/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.Positive;
import org.jetbrains.annotations.NotNull;

public final class PageUtil {
    public static final int DEFAULT_HUGE_PAGE_SIZE = 0x200000;
    private static final Pattern PAGE_SIZE_PATTERN = Pattern.compile("pagesize=([0-9])+([KkMmGg])");
    private static final TrieNode root = new TrieNode();

    static List<String> readMountInfo(String path) {
        try {
            return Files.readAllLines(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            Jvm.warn().on(PageUtil.class, MessageFormat.format("Error reading ''{0}'': {1}", path, e.getMessage()));
            return Collections.emptyList();
        }
    }

    static int parsePageSize(String mount) {
        Matcher matcher = PAGE_SIZE_PATTERN.matcher(mount);
        if (matcher.find()) {
            try {
                return Integer.parseInt(matcher.group(1)) * PageUtil.mult(matcher.group(2));
            }
            catch (Exception e) {
                Jvm.warn().on(PageUtil.class, MessageFormat.format("Error parsing pageSize={0}: {1}", matcher.group(1), e.getMessage()));
            }
        }
        return 0x200000;
    }

    private static int mult(String s) {
        int k = 1024;
        if (s.equalsIgnoreCase("K")) {
            return k;
        }
        if (s.equalsIgnoreCase("G")) {
            return k * 1024 * 1024;
        }
        return k * 1024;
    }

    static String parseMountPoint(String line) {
        String[] parts = line.split("\\s+");
        assert (parts[4].matches("^\\S+$"));
        return parts[4];
    }

    static void insert(String path, int size) {
        TrieNode curr = root;
        for (String dir : path.split("/")) {
            if (dir.isEmpty()) continue;
            curr.childs.putIfAbsent(dir, new TrieNode());
            curr = curr.childs.get(dir);
        }
        curr.isLeaf = true;
        curr.pageSize = size;
        Jvm.perf().on(PageUtil.class, MessageFormat.format("Found pageSize={0} for mount point ''{1}''", size, path));
    }

    @Positive
    public static int getPageSize(@NotNull String absolutePath) {
        if (OS.isLinux()) {
            String[] dirs = absolutePath.split("/");
            TrieNode curr = root;
            for (int i = 0; i < dirs.length && curr != null && !curr.isLeaf; ++i) {
                if (dirs[i].isEmpty()) continue;
                curr = curr.childs.get(dirs[i]);
            }
            if (curr != null && curr.isLeaf && curr.pageSize != 0) {
                return curr.pageSize;
            }
        }
        return OS.defaultOsPageSize();
    }

    public static boolean isHugePage(@NotNull String absolutePath) {
        return OS.isLinux() && PageUtil.getPageSize(absolutePath) != OS.defaultOsPageSize();
    }

    static {
        if (OS.isLinux()) {
            List<String> mounts = PageUtil.readMountInfo("/proc/self/mountinfo");
            for (String mount : mounts) {
                if (!mount.contains("hugetlbfs")) continue;
                int size = PageUtil.parsePageSize(mount);
                String path = PageUtil.parseMountPoint(mount);
                PageUtil.insert(path, size);
            }
        }
    }

    static class TrieNode {
        boolean isLeaf = false;
        final Map<String, TrieNode> childs = new HashMap<String, TrieNode>();
        int pageSize;

        TrieNode() {
        }
    }
}

