/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.GuardedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeBytes<U>
extends VanillaBytes<U> {
    private static final boolean BYTES_GUARDED;
    private static boolean newGuarded;
    protected long capacity;

    public NativeBytes(@NotNull BytesStore store, @NonNegative long capacity) throws IllegalArgumentException, ClosedIllegalStateException {
        super(store, 0L, capacity);
        this.capacity = capacity;
    }

    public NativeBytes(@NotNull BytesStore store) throws IllegalArgumentException, ClosedIllegalStateException {
        this(store, store.capacity());
    }

    public static boolean areNewGuarded() {
        return newGuarded;
    }

    public static boolean setNewGuarded(boolean guarded) {
        newGuarded = guarded;
        return true;
    }

    public static void resetNewGuarded() {
        newGuarded = BYTES_GUARDED;
    }

    @NotNull
    public static NativeBytes<Void> nativeBytes() {
        return NativeBytes.wrapWithNativeBytes(BytesStore.empty(), 0x7FFFFFFFFFFFFFF0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NativeBytes<Void> nativeBytes(@NonNegative long initialCapacity) throws IllegalArgumentException {
        @NotNull BytesStore<?, Void> store = BytesStore.nativeStoreWithFixedCapacity(initialCapacity);
        try {
            NativeBytes<Void> nativeBytes = NativeBytes.wrapWithNativeBytes(store, 0x7FFFFFFFFFFFFFF0L);
            return nativeBytes;
        }
        finally {
            store.release(INIT);
        }
    }

    @Deprecated
    public static BytesStore<Bytes<Void>, Void> copyOf(@NotNull Bytes<?> bytes) throws ClosedIllegalStateException {
        return BytesUtil.copyOf(bytes);
    }

    private static long alignToPageSize(long size) {
        long mask = (long)OS.pageSize() - 1L;
        return size + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @NotNull
    public static <T> NativeBytes<T> wrapWithNativeBytes(@NotNull BytesStore<?, T> bs, @NonNegative long capacity) throws ClosedIllegalStateException, IllegalArgumentException {
        ObjectUtils.requireNonNull(bs);
        return newGuarded ? new GuardedNativeBytes(bs, capacity) : new NativeBytes(bs, capacity);
    }

    protected static <T> long maxCapacityFor(@NotNull BytesStore<?, T> bs) {
        return bs.underlyingObject() instanceof ByteBuffer || bs.underlyingObject() instanceof byte[] ? 0x7FFFFFF0L : 0x7FFFFFFFFFFFFFF0L;
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.capacity;
    }

    @Override
    protected void writeCheckOffset(@NonNegative long offset, @NonNegative long adding) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long writeEnd;
        if (offset >= this.bytesStore.start() && offset + adding >= this.bytesStore.start()) {
            writeEnd = offset + adding;
            if (writeEnd <= this.bytesStore.safeLimit() && !this.isImmutableEmptyByteStore()) {
                return;
            }
            if (writeEnd > this.capacity) {
                throw this.newDBOE(writeEnd);
            }
        } else {
            if (offset < 0L) {
                throw new IllegalArgumentException();
            }
            throw new BufferOverflowException();
        }
        this.checkResize(writeEnd);
    }

    @NotNull
    private DecoratedBufferOverflowException newDBOE(long writeEnd) {
        return new DecoratedBufferOverflowException("Write cannot grow Bytes to " + writeEnd + ", capacity: " + this.capacity);
    }

    @Override
    void prewriteCheckOffset(@NonNegative long offset, long subtracting) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (offset - subtracting >= this.bytesStore.start()) {
            if (offset <= this.bytesStore.safeLimit()) {
                return;
            }
            if (offset >= this.capacity) {
                throw new BufferOverflowException();
            }
        } else {
            throw new BufferOverflowException();
        }
        this.checkResize(offset);
    }

    @Override
    public void ensureCapacity(@NonNegative long desiredCapacity) throws IllegalArgumentException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (desiredCapacity < 0L) {
            throw new IllegalArgumentException();
        }
        assert (DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
        this.writeCheckOffset(desiredCapacity, 0L);
    }

    private void checkResize(@NonNegative long endOfBuffer) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    public boolean isEqual(@NonNegative long start, @NonNegative long length, String s) {
        return this.bytesStore.isEqual(start, length, s);
    }

    private void resize(@NonNegative long endOfBuffer) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfReleased();
        if (endOfBuffer < 0L) {
            throw new DecoratedBufferOverflowException(endOfBuffer + "< 0");
        }
        if (endOfBuffer > this.capacity()) {
            throw new DecoratedBufferOverflowException(endOfBuffer + ">" + this.capacity());
        }
        long realCapacity = this.realCapacity();
        if (endOfBuffer <= realCapacity && !this.isImmutableEmptyByteStore()) {
            return;
        }
        long size = Math.max(endOfBuffer + 7L, realCapacity * 3L / 2L + 32L);
        size = this.isDirectMemory() || size > 0x7FFFFFF0L ? NativeBytes.alignToPageSize(size) : (size &= 0xFFFFFFFFFFFFFFF8L);
        size = Math.min(size, this.capacity());
        boolean isByteBufferBacked = this.bytesStore.underlyingObject() instanceof ByteBuffer;
        if (isByteBufferBacked && size > 0x7FFFFFF0L) {
            StackTrace stackTrace = new StackTrace();
            String stack = BytesUtil.asString("Calling stack is", stackTrace);
            Jvm.warn().on(this.getClass(), "Going to try to replace ByteBuffer-backed BytesStore with raw NativeBytesStore to grow to " + size / 1024L + " KB. If later it is assumed that this bytes' underlyingObject() is ByteBuffer, NullPointerException is likely to be thrown. " + stack);
        }
        if (endOfBuffer >= 131072L && realCapacity > 0L) {
            Jvm.perf().on(this.getClass(), "Resizing buffer was " + realCapacity / 1024L + " KB, needs " + (endOfBuffer - realCapacity) + " bytes more, new-size " + size / 1024L + " KB");
        }
        this.resizeHelper(size, isByteBufferBacked);
    }

    private void resizeHelper(@NonNegative long size, boolean isByteBufferBacked) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        BytesStore store;
        int position = 0;
        try {
            if (isByteBufferBacked && size <= 0x7FFFFFF0L) {
                position = ((ByteBuffer)this.bytesStore.underlyingObject()).position();
                store = this.allocate(size);
            } else {
                store = BytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
                if (this.referenceCounted.unmonitored()) {
                    AbstractReferenceCounted.unmonitor(store);
                }
            }
            store.reserveTransfer(INIT, this);
        }
        catch (IllegalArgumentException e) {
            BufferOverflowException boe = new BufferOverflowException();
            boe.initCause(e);
            throw boe;
        }
        this.throwExceptionIfReleased();
        @Nullable BytesStore tempStore = this.bytesStore;
        this.bytesStore.copyTo(store);
        this.bytesStore(store);
        try {
            tempStore.release(this);
        }
        catch (IllegalStateException e) {
            Jvm.debug().on(this.getClass(), e);
        }
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            @Nullable ByteBuffer byteBuffer = (ByteBuffer)this.bytesStore.underlyingObject();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            byteBuffer.position(position);
        }
    }

    @NotNull
    private BytesStore allocate(@NonNegative long size) {
        BytesStore store = this.allocateNewByteBufferBackedStore(Maths.toInt32(size));
        return store;
    }

    @Override
    protected void bytesStore(@NotNull BytesStore<Bytes<U>, U> bytesStore) {
        if (this.capacity < bytesStore.capacity()) {
            this.capacity = bytesStore.capacity();
        }
        super.bytesStore(bytesStore);
    }

    @Override
    public void bytesStore(@NotNull BytesStore<Bytes<U>, U> byteStore, @NonNegative long offset, @NonNegative long length) throws IllegalArgumentException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(byteStore);
        if (this.capacity < offset + length) {
            this.capacity = offset + length;
        }
        super.bytesStore(byteStore, offset, length);
    }

    @NotNull
    private BytesStore allocateNewByteBufferBackedStore(@NonNegative int size) {
        if (this.isDirectMemory()) {
            return BytesStore.elasticByteBuffer(size, this.capacity());
        }
        return BytesStore.wrap(ByteBuffer.allocate(size));
    }

    @Override
    protected long writeOffsetPositionMoved(@NonNegative long adding, @NonNegative long advance) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long oldPosition = this.writePosition();
        if (this.writePosition() < this.bytesStore.start()) {
            throw new BufferOverflowException();
        }
        long writeEnd = this.writePosition() + adding;
        if (writeEnd > this.writeLimit) {
            this.throwBeyondWriteLimit(advance, writeEnd);
        } else if (writeEnd > this.bytesStore.safeLimit()) {
            this.checkResize(writeEnd);
        }
        this.uncheckedWritePosition(this.writePosition() + advance);
        return oldPosition;
    }

    private void throwBeyondWriteLimit(@NonNegative long advance, @NonNegative long writeEnd) throws DecoratedBufferOverflowException {
        throw new DecoratedBufferOverflowException("attempt to write " + advance + " bytes to " + writeEnd + " limit: " + this.writeLimit);
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(byte i8) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(long i64) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    public long readRemaining() {
        return this.writePosition() - this.readPosition;
    }

    static {
        newGuarded = BYTES_GUARDED = Jvm.getBoolean("bytes.guarded");
    }
}

