/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.harness;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;

public class WeeklyRollCycle
implements RollCycle {
    public static final WeeklyRollCycle INSTANCE = new WeeklyRollCycle("yyyyDDD", (int)TimeUnit.DAYS.toMillis(7L), 16384, 16);
    final String format;
    final int length;
    final RollCycleArithmetic arithmetic;

    WeeklyRollCycle(String format, int length, int indexCount, int indexSpacing) {
        this.format = format;
        this.length = length;
        this.arithmetic = RollCycleArithmetic.of((int)indexCount, (int)indexSpacing);
    }

    public String format() {
        return this.format;
    }

    public int lengthInMillis() {
        return this.length;
    }

    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }

    public long maxMessagesPerCycle() {
        return this.arithmetic.maxMessagesPerCycle();
    }
}

