/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.channel.PipeHandler;
import net.openhft.chronicle.queue.channel.Says;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.ChronicleGatewayMain;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PipeHandlerTest
extends QueueTestCommon {
    private final boolean buffered;

    public PipeHandlerTest(boolean buffered) {
        this.buffered = buffered;
    }

    @Parameterized.Parameters(name="buffered: {0}")
    public static List<Object[]> combinations() {
        Object[][] comb = new Object[][]{{true}, {false}};
        return Arrays.asList(comb);
    }

    @Before
    public void deleteQueues() {
        IOTools.deleteDirWithFiles((String[])new String[]{"test-q"});
    }

    @Test
    @Ignore
    public void internal() {
        String url = "internal://";
        try (ChronicleContext context = ChronicleContext.newContext((String)url).buffered(this.buffered);){
            this.doTest(context);
        }
    }

    @Test
    public void clientOnly() throws IOException {
        String url = "tcp://localhost:65441";
        IOTools.deleteDirWithFiles((String[])new String[]{"target/client", "target/gw"});
        try (ChronicleContext context = ChronicleContext.newContext((String)url).name("target/client").buffered(this.buffered);){
            ChronicleGatewayMain gateway = new ChronicleGatewayMain(url);
            gateway.name("target/gw");
            context.addCloseable((Closeable)gateway);
            gateway.start();
            this.doTest(context);
        }
    }

    @Test
    public void server() {
        String url = "tcp://:0";
        IOTools.deleteDirWithFiles((String[])new String[]{"target/server"});
        try (ChronicleContext context = ChronicleContext.newContext((String)url).name("target/server").buffered(this.buffered);){
            this.doTest(context);
        }
    }

    @Test
    public void redirectedServer() throws IOException {
        IOTools.deleteDirWithFiles((String[])new String[]{"target/zero", "target/one", "target/client"});
        Assume.assumeFalse((boolean)Jvm.isDebug());
        final String urlZzz = "tcp://localhost:65329";
        final String url0 = "tcp://localhost:65330";
        String url1 = "tcp://localhost:65331";
        try (ChronicleGatewayMain gateway0 = new ChronicleGatewayMain(url0).buffered(this.buffered);){
            gateway0.name("target/zero");
            gateway0.start();
            try (ChronicleGatewayMain gateway1 = new ChronicleGatewayMain(url1){

                protected ChannelHeader replaceOutHeader(ChannelHeader channelHeader) {
                    return new RedirectHeader(Arrays.asList(urlZzz, url0));
                }
            }.buffered(this.buffered);){
                gateway1.name("target/one");
                gateway1.start();
                try (ChronicleContext context = ChronicleContext.newContext((String)url1).name("target/client").buffered(this.buffered);){
                    this.doTest(context);
                }
            }
        }
    }

    private void doTest(ChronicleContext context) {
        ChronicleChannel channel = context.newChannelSupplier((ChannelHandler)new PipeHandler().subscribe("test-q").publish("test-q")).get();
        Says says = (Says)channel.methodWriter(Says.class, new Class[0]);
        says.say("Hello World");
        StringBuilder eventType = new StringBuilder();
        String text = (String)channel.readOne(eventType, String.class);
        Assert.assertEquals((Object)"say: Hello World", (Object)(eventType + ": " + text));
        try (DocumentContext dc = channel.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
            Assert.assertFalse((boolean)dc.isMetaData());
        }
        long now = SystemTimeProvider.CLOCK.currentTimeNanos();
        channel.testMessage(now);
        try (DocumentContext dc = channel.readingDocument();){
            Assert.assertTrue((boolean)dc.isPresent());
            Assert.assertTrue((boolean)dc.isMetaData());
        }
        Assert.assertEquals((long)now, (long)channel.lastTestMessage());
    }
}

