/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IncompleteMessageTest
extends QueueTestCommon {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void incompleteMessageShouldBeSkipped() throws Exception {
        Throwable throwable;
        ExcerptAppender appender;
        System.setProperty("queue.force.unlock.mode", "ALWAYS");
        this.expectException("Couldn't acquire write lock after ");
        this.expectException("Forced unlock for the lock ");
        this.ignoreException("Unable to release the lock");
        try (SingleChronicleQueue queue = this.createQueue();){
            appender = queue.acquireAppender();
            throwable = null;
            try {
                appender.writeDocument((Object)"hello", ValueOut::text);
                DocumentContext documentContext = appender.writingDocument();
                documentContext.wire().bytes().write("incomplete longer write".getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (appender != null) {
                    if (throwable != null) {
                        try {
                            appender.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        appender.close();
                    }
                }
            }
        }
        try {
            queue = this.createQueue();
            var2_2 = null;
            try {
                appender = queue.acquireAppender();
                throwable = null;
                try {
                    appender.writeDocument((Object)"world", ValueOut::text);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (appender != null) {
                        if (throwable != null) {
                            try {
                                appender.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            appender.close();
                        }
                    }
                }
                throwable = null;
                try (ExcerptTailer tailer = queue.createTailer();){
                    tailer.toStart();
                    Assert.assertEquals((Object)"hello", (Object)tailer.readText());
                    Assert.assertEquals((Object)"world", (Object)tailer.readText());
                    Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                var2_2 = throwable7;
                throw throwable7;
            }
            finally {
                if (queue != null) {
                    if (var2_2 != null) {
                        try {
                            queue.close();
                        }
                        catch (Throwable throwable8) {
                            var2_2.addSuppressed(throwable8);
                        }
                    } else {
                        queue.close();
                    }
                }
            }
        }
        finally {
            System.clearProperty("queue.force.unlock.mode");
        }
    }

    private SingleChronicleQueue createQueue() {
        return SingleChronicleQueueBuilder.binary((File)this.tmpDir.getRoot()).timeoutMS(250L).build();
    }
}

