/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.AccessDeniedException;
import java.util.Arrays;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ReadWriteTest
extends QueueTestCommon {
    private static final String STR1 = "hello";
    private static final String STR2 = "hey";
    private File chroniclePath;

    @Before
    public void setup() {
        this.chroniclePath = new File(OS.getTarget(), "read_only_" + Time.uniqueId());
        try (SingleChronicleQueue readWrite = ChronicleQueue.singleBuilder((File)this.chroniclePath).readOnly(false).testBlockSize().build();){
            ExcerptAppender appender = readWrite.acquireAppender();
            appender.writeText((CharSequence)STR1);
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeUtf8(STR2);
            }
        }
    }

    @Override
    public void tearDown() {
        try {
            IOTools.shallowDeleteDirWithFiles((File)this.chroniclePath);
        }
        catch (Exception e) {
            if (e instanceof AccessDeniedException && OS.isWindows()) {
                System.err.println(e);
            }
            throw e;
        }
    }

    @Test
    public void testReadFromReadOnlyChronicle() {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            Assert.assertTrue((out.dump().length() > 1 ? 1 : 0) != 0);
            ExcerptTailer tailer = out.createTailer();
            Assert.assertEquals((Object)STR1, (Object)tailer.readText());
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)STR2, (Object)dc.wire().bytes().readUtf8());
            }
        }
    }

    @Test
    public void testNotInitializedMetadataFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        String expectedException = "Failback to readonly tablestore";
        this.expectException("Failback to readonly tablestore");
        System.out.println("This test will produce a Failback to readonly tablestore");
        File meta = new File(this.chroniclePath, "metadata.cq4t");
        Assert.assertTrue((boolean)meta.exists());
        try (RandomAccessFile raf = new RandomAccessFile(meta, "rw");){
            raf.setLength(0L);
        }
        var4_4 = null;
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testProceedWhenMetadataFileInitialized() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        File meta = new File(this.chroniclePath, "metadata.cq4t");
        Assert.assertTrue((boolean)meta.exists());
        try (RandomAccessFile raf = new RandomAccessFile(meta, "rw");){
            raf.setLength(0L);
        }
        new Thread(() -> {
            Jvm.pause((long)200L);
            SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().build();
            Throwable throwable = null;
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    out.close();
                }
            }
        }).start();
        var3_3 = null;
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteToReadOnlyChronicle() {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test read only mode on windows");
            throw new IllegalStateException("not run");
        }
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            out.acquireAppender();
        }
    }

    @Test
    public void testToEndOnReadOnly() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
    }

    @Test
    public void testNonWriteableFilesSetToReadOnly() {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.expectException("Failback to readonly tablestore");
        this.expectException("Forcing queue to be readOnly");
        Arrays.stream(this.chroniclePath.list()).forEach(s -> Assert.assertTrue((boolean)new File(this.chroniclePath, (String)s).setWritable(false)));
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(false).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
    }
}

