/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import net.openhft.chronicle.queue.MappedFileUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MappedFileUtilTest {
    private final String procMapsLine;
    private final String expectedPath;
    private final String expectedAddress;

    @Parameterized.Parameters(name="line={0} should resolve path={1} and address={2}")
    public static List<Object[]> exampleLines() {
        return Arrays.asList({"7f3b9ee38000-7f3b9ee3b000 r--p 00000000 103:03 3147723                   /usr/lib/x86_64-linux-gnu/libgcc_s.so.1", "/usr/lib/x86_64-linux-gnu/libgcc_s.so.1", "7f3b9ee38000-7f3b9ee3b000"}, {"d0000000-e4b00000 rw-p 00000000 00:00 0", "", "d0000000-e4b00000"}, {"100240000-140000000 ---p 00000000 00:00 0", "", "100240000-140000000"}, {"564609d75000-564609d76000 r--p 00000000 fe:02 15994495                   /usr/lib/jvm/java-8-openjdk/jre/bin/java", "/usr/lib/jvm/java-8-openjdk/jre/bin/java", "564609d75000-564609d76000"}, {"56460ac26000-56460ac47000 rw-p 00000000 00:00 0                          [heap]", "[heap]", "56460ac26000-56460ac47000"}, {"7f22b44b3000-7f22b44b4000 r--s 00001000 fe:02 11535264                   /opt/intellij-idea-ultimate-edition/plugins/maven/lib/maven-event-listener.jar", "/opt/intellij-idea-ultimate-edition/plugins/maven/lib/maven-event-listener.jar", "7f22b44b3000-7f22b44b4000"}, {"ffffffffff600000-ffffffffff601000 --xp 00000000 00:00 0                  [vsyscall]", "[vsyscall]", "ffffffffff600000-ffffffffff601000"});
    }

    public MappedFileUtilTest(String procMapsLine, String expectedPath, String expectedAddress) {
        this.procMapsLine = procMapsLine;
        this.expectedPath = expectedPath;
        this.expectedAddress = expectedAddress;
    }

    @Test
    public void shouldParseExampleLine() {
        Matcher matcher = MappedFileUtil.parseMapsLine(this.procMapsLine);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((Object)this.expectedPath, (Object)MappedFileUtil.getPath(matcher));
        Assert.assertEquals((Object)this.expectedAddress, (Object)MappedFileUtil.getAddress(matcher));
    }
}

