/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.micros;

import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.micros.SidedPrice;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.jetbrains.annotations.NotNull;

public class TopOfBookPrice
extends SelfDescribingMarshallable {
    public static final long TIMESTAMP_LIMIT = TimeUnit.SECONDS.toMillis(1000L);
    final String symbol;
    long timestamp;
    double buyPrice;
    double buyQuantity;
    double sellPrice;
    double sellQuantity;

    public TopOfBookPrice(String symbol, long timestamp, double buyPrice, double buyQuantity, double sellPrice, double sellQuantity) {
        this.symbol = symbol;
        this.timestamp = timestamp;
        this.buyPrice = buyPrice;
        this.buyQuantity = buyQuantity;
        this.sellPrice = sellPrice;
        this.sellQuantity = sellQuantity;
    }

    public TopOfBookPrice(String symbol) {
        this.symbol = symbol;
        this.timestamp = 0L;
        this.sellPrice = Double.NaN;
        this.buyPrice = Double.NaN;
        this.sellQuantity = 0.0;
        this.buyQuantity = 0.0;
    }

    public boolean combine(@NotNull SidedPrice price) {
        boolean changed = false;
        switch (price.side) {
            case Buy: {
                boolean bl = changed = this.timestamp + TIMESTAMP_LIMIT < price.timestamp || this.buyPrice != price.price || this.buyQuantity != price.quantity;
                if (!changed) break;
                this.timestamp = price.timestamp;
                this.buyPrice = price.price;
                this.buyQuantity = price.quantity;
                break;
            }
            case Sell: {
                boolean bl = changed = this.timestamp + TIMESTAMP_LIMIT < price.timestamp || this.sellPrice != price.price || this.sellQuantity != price.quantity;
                if (!changed) break;
                this.timestamp = price.timestamp;
                this.sellPrice = price.price;
                this.sellQuantity = price.quantity;
            }
        }
        return changed;
    }
}

