/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import java.util.function.Function;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.channel.DummyData;
import net.openhft.chronicle.queue.channel.Echoed;
import net.openhft.chronicle.queue.channel.Echoing;
import net.openhft.chronicle.queue.channel.EchoingMicroservice;
import net.openhft.chronicle.queue.channel.PipeHandler;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelSupplier;
import net.openhft.chronicle.wire.channel.ChronicleContext;

public class Main {
    public static void main(String[] args) {
        String in = "in";
        String out = "out";
        IOTools.deleteDirWithFiles((String[])new String[]{"in", "out"});
        try (ChronicleContext context = ChronicleContext.newContext((String)args[0]);){
            PipeHandler handler0 = new PipeHandler().publish("in").subscribe("out");
            Runnable runs = Main.serviceAsRunnable(context, (ChannelHandler)handler0, EchoingMicroservice::new, Echoed.class);
            new Thread(runs).start();
            PipeHandler handler = new PipeHandler().publish("out").subscribe("in");
            ChronicleChannel channel = context.newChannelSupplier((ChannelHandler)handler).get();
            Echoing echoing = (Echoing)channel.methodWriter(Echoing.class, new Class[0]);
            echoing.echo(new DummyData());
            try (DocumentContext dc = channel.readingDocument();){
                DummyData dummyData = (DummyData)((Object)dc.wire().read("echoed").object(DummyData.class));
            }
        }
    }

    public static <I, O> Runnable serviceAsRunnable(ChronicleContext context, ChannelHandler handler, Function<O, I> msFunction, Class<O> tClass) {
        ChronicleChannelSupplier supplier0 = context.newChannelSupplier(handler);
        ChronicleChannel channel0 = supplier0.get();
        I microservice = msFunction.apply(channel0.methodWriter(tClass, new Class[0]));
        return channel0.eventHandlerAsRunnable(microservice);
    }
}

