/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;

public class TextWriteDocumentContext
implements WriteDocumentContext {
    protected Wire wire;
    private boolean metaData;
    private volatile boolean notComplete;
    protected int count = 0;
    private boolean chainedElement;
    private boolean rollback;

    public TextWriteDocumentContext(Wire wire) {
        this.wire = wire;
    }

    @Override
    public void start(boolean metaData) {
        ++this.count;
        if (this.count > 1) {
            assert (metaData == this.isMetaData());
            return;
        }
        this.metaData = metaData;
        if (metaData) {
            this.wire().writeComment("meta-data");
        }
        this.notComplete = true;
        this.chainedElement = false;
        this.rollback = false;
    }

    @Override
    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void close() {
        if (this.chainedElement) {
            return;
        }
        --this.count;
        if (this.count > 0) {
            return;
        }
        @NotNull Bytes<?> bytes = this.wire().bytes();
        if (this.rollback) {
            bytes.writePosition(bytes.readPosition());
            return;
        }
        long l = bytes.writePosition();
        if (!(this.wire() instanceof JSONWire)) {
            if (l < 1L || bytes.peekUnsignedByte(l - 1L) >= 32) {
                bytes.append('\n');
            }
            BytesUtil.combineDoubleNewline(bytes);
            bytes.append("...\n");
        }
        this.wire().getValueOut().resetBetweenDocuments();
        this.notComplete = false;
    }

    @Override
    public void reset() {
        this.chainedElement = false;
        if (this.count > 0) {
            this.close();
        }
        this.count = 0;
        this.rollback = false;
        this.notComplete = false;
    }

    @Override
    public void rollbackOnClose() {
        this.rollback = true;
    }

    @Override
    public boolean chainedElement() {
        return this.chainedElement;
    }

    @Override
    public void chainedElement(boolean chainedElement) {
        this.chainedElement = chainedElement;
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public Wire wire() {
        return this.wire;
    }

    @Override
    public long index() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sourceId() {
        return -1;
    }

    @Override
    public boolean isNotComplete() {
        return this.notComplete;
    }
}

