/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.rollcycles;

import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;

public enum TestRollCycles implements RollCycle
{
    TEST_SECONDLY("yyyyMMdd-HHmmss'T'", 1000, 32768, 4),
    TEST4_SECONDLY("yyyyMMdd-HHmmss'T4'", 1000, 32, 4),
    TEST_HOURLY("yyyyMMdd-HH'T'", 3600000, 16, 4),
    TEST_DAILY("yyyyMMdd'T1'", 86400000, 8, 1),
    TEST2_DAILY("yyyyMMdd'T2'", 86400000, 16, 2),
    TEST4_DAILY("yyyyMMdd'T4'", 86400000, 32, 4),
    TEST8_DAILY("yyyyMMdd'T8'", 86400000, 128, 8);

    private final String format;
    private final int lengthInMillis;
    private final RollCycleArithmetic arithmetic;

    private TestRollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.arithmetic = RollCycleArithmetic.of(indexCount, indexSpacing);
    }

    @Override
    public long maxMessagesPerCycle() {
        return this.arithmetic.maxMessagesPerCycle();
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    @Override
    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    @Override
    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    @Override
    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }
}

