/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.GcControls;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.Assert;
import org.junit.Test;

public final class TailerPollingEmptyQueueTest
extends QueueTestCommon {
    @Test
    public void shouldNotGenerateExcessGarbage() {
        try (SingleChronicleQueue queue = this.createQueue();){
            queue.path.mkdirs();
            Assert.assertEquals((long)0L, (long)queue.path.list((d, n) -> n.endsWith(".cq4")).length);
            ExcerptTailer tailer = queue.createTailer();
            for (int i = 0; i < 50; ++i) {
                Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            }
            long startCollectionCount = GcControls.getGcCount();
            for (int i = 0; i < 1000000; ++i) {
                Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
            }
            Assert.assertEquals((long)0L, (long)(GcControls.getGcCount() - startCollectionCount));
        }
    }

    private SingleChronicleQueue createQueue() {
        return ChronicleQueue.singleBuilder((File)this.getTmpDir()).testBlockSize().build();
    }
}

