/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Assert;
import org.junit.Test;

public class AcquireReleaseTest
extends QueueTestCommon {
    @Test
    public void testAcquireAndRelease() {
        File dir = IOTools.createTempDirectory((String)"testAcquireAndRelease").toFile();
        final AtomicInteger acount = new AtomicInteger();
        final AtomicInteger qcount = new AtomicInteger();
        StoreFileListener sfl = new StoreFileListener(){

            public void onAcquired(int cycle, File file) {
                acount.incrementAndGet();
            }

            public void onReleased(int cycle, File file) {
                qcount.incrementAndGet();
            }
        };
        AtomicLong time = new AtomicLong(1000L);
        TimeProvider tp = () -> time.getAndAccumulate(1000L, (x, y) -> x + y);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).storeFileListener(sfl).timeProvider(tp).build();){
            int iter = 4;
            try (ExcerptAppender excerptAppender = queue.acquireAppender();){
                for (int i = 0; i < iter; ++i) {
                    excerptAppender.writeDocument(w -> w.write((CharSequence)"a").marshallable(m -> m.write((CharSequence)"b").text("c")));
                }
            }
            BackgroundResourceReleaser.releasePendingResources();
            Assert.assertEquals((long)iter, (long)acount.get());
            Assert.assertEquals((long)iter, (long)qcount.get());
        }
    }

    @Test
    public void testReserveAndRelease() {
        File dir = this.getTmpDir();
        SetTimeProvider stp = new SetTimeProvider();
        stp.currentTimeMillis(1000L);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();){
            queue.acquireAppender().writeText((CharSequence)"Hello World");
            stp.currentTimeMillis(2000L);
            queue.acquireAppender().writeText((CharSequence)"Hello World");
            queue.createTailer().readText();
            try (ExcerptTailer tailer = queue.createTailer();){
                tailer.readText();
                tailer.readText();
                tailer.readText();
            }
        }
    }

    @Test
    public void testWithCleanupStoreFilesWithNoDataAcquireAndRelease() throws InterruptedException, ExecutionException {
        File dir = this.getTmpDir();
        SetTimeProvider stp = new SetTimeProvider();
        final AtomicInteger acount = new AtomicInteger();
        final AtomicInteger qcount = new AtomicInteger();
        StoreFileListener storeFileListener = new StoreFileListener(){

            public void onAcquired(int cycle, File file) {
                acount.incrementAndGet();
            }

            public void onReleased(int cycle, File file) {
                qcount.incrementAndGet();
            }
        };
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).storeFileListener(storeFileListener).timeProvider((TimeProvider)stp).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"Main thread: Hello world");
            BackgroundResourceReleaser.releasePendingResources();
            Assert.assertEquals((long)1L, (long)acount.get());
            stp.advanceMillis(1000L);
            CompletableFuture.runAsync(() -> ((SingleChronicleQueue)queue).acquireAppender()).get();
        }
        BackgroundResourceReleaser.releasePendingResources();
        Assert.assertEquals((long)3L, (long)acount.get());
        Assert.assertEquals((long)3L, (long)qcount.get());
    }
}

