/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Type;
import java.util.Base64;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QueryWire
extends TextWire {
    final QueryValueOut valueOut = new QueryValueOut();
    final QueryValueIn valueIn = new QueryValueIn();

    public QueryWire(@NotNull Bytes<?> bytes) {
        super(bytes);
    }

    @Override
    @NotNull
    protected QueryValueOut createValueOut() {
        return new QueryValueOut();
    }

    @Override
    @NotNull
    protected TextWire.TextValueIn createValueIn() {
        return new QueryValueIn();
    }

    @Override
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.consumePadding();
        this.bytes.parseUtf8((Appendable)sb, QueryStopCharTesters.QUERY_FIELD_NAME);
        if (this.rewindAndRead() == 38) {
            this.bytes.readSkip(-1L);
        }
        return sb;
    }

    @Override
    @ForceInline
    public void consumePadding() {
        int codePoint = this.peekCode();
        while (Character.isWhitespace(codePoint)) {
            this.bytes.readSkip(1L);
            codePoint = this.peekCode();
        }
    }

    @Override
    @NotNull
    public ValueOut write() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        return this.valueOut.write(key);
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence name) {
        return this.valueOut.write(name);
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public QueryWire writeComment(@NotNull CharSequence s) {
        return this;
    }

    @Override
    @NotNull
    public QueryWire addPadding(int paddingToAdd) {
        return this;
    }

    int rewindAndRead() {
        return this.bytes.readUnsignedByte(this.bytes.readPosition() - 1L);
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        throw new UnsupportedOperationException();
    }

    class QueryValueIn
    extends TextWire.TextValueIn {
        QueryValueIn() {
            super(QueryWire.this);
        }

        @Override
        public String text() {
            return StringUtils.toString(this.textTo(WireInternal.acquireStringBuilder()));
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder a) {
            QueryWire.this.consumePadding();
            QueryWire.this.bytes.parseUtf8((Appendable)a, QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> a) {
            QueryWire.this.consumePadding();
            QueryWire.this.bytes.parseUtf8(a, QueryStopCharTesters.QUERY_VALUE);
            return a;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            classNameConsumer.accept(t, sb);
            return this.wireIn();
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            StringBuilder sb = WireInternal.acquireStringBuilder();
            this.textTo(sb);
            return this.classLookup().forName(sb);
        }

        @Override
        public boolean hasNextSequenceItem() {
            QueryWire.this.consumePadding();
            int ch = QueryWire.this.peekCode();
            if (ch == 44) {
                QueryWire.this.bytes.readSkip(1L);
                return true;
            }
            return ch != 93;
        }
    }

    class QueryValueOut
    extends YamlWireOut.YamlValueOut {
        @NotNull
        String sep;
        @Nullable
        CharSequence fieldName;

        QueryValueOut() {
            super(QueryWire.this);
            this.sep = "";
            this.fieldName = null;
        }

        @Override
        void prependSeparator() {
            QueryWire.this.bytes.appendUtf8(this.sep);
            this.sep = "";
            if (this.fieldName != null) {
                ((Bytes)QueryWire.this.bytes.appendUtf8(this.fieldName)).appendUtf8(61);
                this.fieldName = null;
            }
        }

        @Override
        public void elementSeparator() {
            this.sep = "&";
        }

        @Override
        @NotNull
        public QueryWire bool(@Nullable Boolean flag) {
            if (flag != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8(flag != false ? "true" : "false");
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire text(@Nullable CharSequence s) {
            if (s != null) {
                this.prependSeparator();
                QueryWire.this.bytes.appendUtf8(s);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire int8(byte i8) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(i8);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire bytes(@Nullable BytesStore fromBytes) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        @NotNull
        public QueryWire rawBytes(@Nullable byte[] value) {
            if (value != null) {
                this.prependSeparator();
                QueryWire.this.bytes.write(value);
                this.elementSeparator();
            }
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire bytes(byte[] byteArray) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(Base64.getEncoder().encodeToString(byteArray));
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire int64array(long capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire int64array(long capacity, @NotNull LongArrayValues values) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryValueOut typePrefix(@NotNull CharSequence typeName) {
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8(typeName);
            this.sep = " ";
            return this;
        }

        @Override
        @NotNull
        public QueryWire typeLiteral(@Nullable CharSequence type) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> typeTranslator, @NotNull Class type) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire int32forBinding(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire int32forBinding(int value, @NotNull IntValue intValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire int64forBinding(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryWire int64forBinding(long value, @NotNull LongValue longValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> QueryWire sequence(T t, @NotNull BiConsumer<T, ValueOut> writer) {
            this.prependSeparator();
            this.pushState();
            QueryWire.this.bytes.appendUtf8("[");
            this.sep = ",";
            long pos = QueryWire.this.bytes.writePosition();
            writer.accept(t, this);
            if (pos != QueryWire.this.bytes.writePosition()) {
                QueryWire.this.bytes.appendUtf8(",");
            }
            this.popState();
            QueryWire.this.bytes.appendUtf8("]");
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public <T, K> QueryWire sequence(T t, K kls, @NotNull TriConsumer<T, K, ValueOut> writer) {
            this.prependSeparator();
            this.pushState();
            QueryWire.this.bytes.appendUtf8("[");
            this.sep = ",";
            long pos = QueryWire.this.bytes.writePosition();
            writer.accept(t, kls, this);
            if (pos != QueryWire.this.bytes.writePosition()) {
                QueryWire.this.bytes.appendUtf8(",");
            }
            this.popState();
            QueryWire.this.bytes.appendUtf8("]");
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        protected void popState() {
        }

        @Override
        protected void pushState() {
        }

        @Override
        @NotNull
        public QueryWire marshallable(@NotNull WriteMarshallable object) {
            this.pushState();
            this.prependSeparator();
            QueryWire.this.bytes.appendUtf8("{");
            this.sep = ",";
            object.writeMarshallable(QueryWire.this);
            this.popState();
            QueryWire.this.bytes.appendUtf8(125);
            this.elementSeparator();
            return QueryWire.this;
        }

        @Override
        @NotNull
        public QueryWire map(@NotNull Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryValueOut write() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public QueryValueOut write(@NotNull WireKey key) {
            this.fieldName = key.name();
            return this;
        }

        @Override
        @NotNull
        public QueryValueOut write(@NotNull CharSequence name) {
            this.fieldName = name;
            return this;
        }
    }

    static enum QueryStopCharTesters implements StopCharTester
    {
        QUERY_FIELD_NAME{

            @Override
            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch == 61 || ch < 0;
            }
        }
        ,
        QUERY_VALUE{

            @Override
            public boolean isStopChar(int ch) throws IllegalStateException {
                return ch == 38 || ch < 0;
            }
        };

    }
}

