/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategy;
import net.openhft.affinity.CpuLayout;

public enum AffinityStrategies implements AffinityStrategy
{
    ANY{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            return true;
        }
    }
    ,
    SAME_CORE{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) == cpuLayout.socketId(cpuId2) && cpuLayout.coreId(cpuId) == cpuLayout.coreId(cpuId2);
        }
    }
    ,
    SAME_SOCKET{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) == cpuLayout.socketId(cpuId2) && cpuLayout.coreId(cpuId) != cpuLayout.coreId(cpuId2);
        }
    }
    ,
    DIFFERENT_CORE{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) != cpuLayout.socketId(cpuId2) || cpuLayout.coreId(cpuId) != cpuLayout.coreId(cpuId2);
        }
    }
    ,
    DIFFERENT_SOCKET{

        @Override
        public boolean matches(int cpuId, int cpuId2) {
            CpuLayout cpuLayout = AffinityLock.cpuLayout();
            return cpuLayout.socketId(cpuId) != cpuLayout.socketId(cpuId2);
        }
    };

}

