/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.junit.Assert;
import org.junit.Test;

public class TestTailAfterRoll
extends QueueTestCommon {
    private static final String EXPECTED = "hello world  3";

    @Test
    public void test() {
        File[] files;
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue writeQ = ChronicleQueue.singleBuilder((File)tmpDir).build();
             ExcerptAppender appender = writeQ.createAppender();){
            long wp;
            Wire wire;
            try (DocumentContext dc = appender.writingDocument();){
                wire = dc.wire();
                wire.write().text("hello world");
                Bytes bytes = wire.bytes();
                wp = bytes.writePosition();
            }
            File dir = new File(appender.queue().fileAbsolutePath());
            files = dir.listFiles(pathname -> pathname.getAbsolutePath().endsWith(".cq4"));
            wire.bytes().writeInt(wp, -1073741824);
            appender.writeText((CharSequence)"hello world  2");
        }
        Assert.assertEquals((long)1L, (long)files.length);
        File file = files[0];
        file.delete();
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((File)tmpDir).build();
             ExcerptAppender appender = q.createAppender();){
            ExcerptTailer excerptTailer = q.createTailer().toEnd();
            appender.writeText((CharSequence)EXPECTED);
            Assert.assertEquals((Object)EXPECTED, (Object)excerptTailer.readText());
        }
    }
}

