/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.BinarySearch;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestBinarySearch
extends QueueTestCommon {
    private final int numberOfMessages;

    public TestBinarySearch(int numberOfMessages) {
        this.numberOfMessages = numberOfMessages;
    }

    @Parameterized.Parameters(name="items in queue: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {1}, {2}, {100});
    }

    @Test
    public void testBinarySearch() throws ParseException {
        SetTimeProvider stp = new SetTimeProvider();
        long time = 0L;
        stp.currentTimeMillis(time);
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)this.getTmpDir()).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).timeProvider((TimeProvider)stp).build();
             ExcerptAppender appender = queue.createAppender();){
            Throwable throwable;
            for (int i = 0; i < this.numberOfMessages; ++i) {
                throwable = null;
                try (DocumentContext dc = appender.writingDocument();){
                    MyData myData = new MyData();
                    myData.key = i;
                    myData.value = "some value where the key=" + i;
                    dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
                    stp.currentTimeMillis(time += 300L);
                    continue;
                }
                catch (Throwable myData) {
                    throwable = myData;
                    throw myData;
                }
            }
            Comparator comparator = (o1, o2) -> {
                long readPositionO1 = o1.bytes().readPosition();
                long readPositionO2 = o2.bytes().readPosition();
                try {
                    int compare;
                    MyData myDataO2;
                    MyData myDataO1;
                    try (DocumentContext dc = o1.readingDocument();){
                        myDataO1 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                    }
                    try (DocumentContext dc = o2.readingDocument();){
                        myDataO2 = (MyData)((Object)((Object)dc.wire().getValueIn().typedMarshallable()));
                    }
                    int n = compare = Integer.compare(myDataO1.key, myDataO2.key);
                    return n;
                }
                finally {
                    o1.bytes().readPosition(readPositionO1);
                    o2.bytes().readPosition(readPositionO2);
                }
            };
            throwable = null;
            try (ExcerptTailer tailer = queue.createTailer();
                 ExcerptTailer binarySearchTailer = queue.createTailer();){
                for (int j = 0; j < this.numberOfMessages; ++j) {
                    try (DocumentContext ignored = tailer.readingDocument();){
                        Wire key = this.toWire(j);
                        long index = BinarySearch.search((ExcerptTailer)binarySearchTailer, (Wire)key, (Comparator)comparator);
                        Assert.assertEquals((long)tailer.index(), (long)index);
                        key.bytes().releaseLast();
                        continue;
                    }
                }
                Wire key = this.toWire(this.numberOfMessages);
                Assert.assertTrue((String)"Should not find non-existent", (BinarySearch.search((ExcerptTailer)tailer, (Wire)key, (Comparator)comparator) < 0L ? 1 : 0) != 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @NotNull
    private Wire toWire(int key) {
        MyData myData = new MyData();
        myData.key = key;
        myData.value = Integer.toString(key);
        Wire wire = (Wire)WireType.BINARY.apply((Object)Bytes.elasticByteBuffer());
        wire.usePadding(true);
        try (DocumentContext dc = wire.writingDocument();){
            dc.wire().getValueOut().typedMarshallable((WriteMarshallable)myData);
        }
        return wire;
    }

    public static class MyData
    extends SelfDescribingMarshallable {
        private int key;
        private String value;

        @NotNull
        public String toString() {
            return "MyData{key=" + this.key + ", value='" + this.value + '\'' + '}';
        }
    }
}

