/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Clock;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.queue.util.QueueUtil;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class SingleCQFormatTest
extends QueueTestCommon {
    @Test
    public void testEmptyDirectory() {
        File dir = new File(OS.getTarget(), this.getClass().getSimpleName() + "-" + Time.uniqueId());
        dir.mkdir();
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();){
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)queue.firstCycle());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)queue.firstIndex());
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)queue.lastCycle());
        }
        IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
    }

    @Test
    public void testInvalidFile() throws FileNotFoundException {
        this.expectException("Overriding roll cycle from TEST4_DAILY to DAILY");
        File dir = new File(OS.getTarget() + "/deleteme-" + Time.uniqueId());
        dir.mkdir();
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700102.cq4"), (long)65536L);){
            bytes.write8bit("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>");
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).testBlockSize().build();){
                Assert.assertEquals((long)1L, (long)queue.firstCycle());
                Assert.assertEquals((long)1L, (long)queue.lastCycle());
                try {
                    ExcerptTailer tailer = queue.createTailer();
                    tailer.toEnd();
                    Assert.fail();
                }
                catch (Exception e) {
                    Assert.assertEquals((Object)"java.io.StreamCorruptedException: Unexpected magic number 783f3c37", (Object)e.toString());
                }
            }
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoHeader() throws IOException {
        this.ignoreException("Channel closed while unlocking");
        File dir = new File(OS.getTarget() + "/deleteme-" + Time.uniqueId());
        dir.mkdir();
        File file = new File(dir, "19700101.cq4");
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] bytes = new byte[1024];
            for (int i = 0; i < 128; ++i) {
                fos.write(bytes);
            }
        }
        try {
            var4_5 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)LegacyRollCycles.DAILY).timeoutMS(500L).testBlockSize().build();){
                this.testQueue((ChronicleQueue)queue);
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
        }
        finally {
            try {
                IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadHeader() throws IOException {
        this.ignoreException("Channel closed while unlocking");
        File dir = this.getTmpDir();
        dir.mkdirs();
        File file = new File(dir, "19700101.cq4");
        file.createNewFile();
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)QueueUtil.testBlockSize());
        try {
            bytes.writeInt(-1073741824);
        }
        finally {
            bytes.releaseLast();
        }
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).timeoutMS(500L).testBlockSize().blockSize(QueueUtil.testBlockSize()).build();){
            this.testQueue((ChronicleQueue)queue);
        }
        finally {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeadHeaderAppend() throws IOException {
        this.ignoreException("Channel closed while unlocking");
        this.expectException("Renamed un-acquirable segment file to");
        File dir = this.getTmpDir();
        dir.mkdirs();
        File file = new File(dir, LocalDate.now(Clock.systemUTC()).format(DateTimeFormatter.ofPattern("yyyyMMdd")) + ".cq4");
        file.createNewFile();
        MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)QueueUtil.testBlockSize());
        try {
            bytes.writeInt(-1073741824);
        }
        finally {
            bytes.releaseLast();
        }
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).timeoutMS(500L).testBlockSize().blockSize(QueueUtil.testBlockSize()).build();){
            try (ExcerptAppender appender = queue.createAppender();){
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"foo");
                }
                dc = appender.writingDocument();
                var9_14 = null;
                try {
                    dc.wire().write((CharSequence)"bar");
                }
                catch (Throwable throwable) {
                    var9_14 = throwable;
                    throw throwable;
                }
                finally {
                    if (dc != null) {
                        if (var9_14 != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable) {
                                var9_14.addSuppressed(throwable);
                            }
                        } else {
                            dc.close();
                        }
                    }
                }
            }
            Assert.assertEquals((long)1L, (long)dir.listFiles((d, name) -> name.startsWith(file.getName()) && name.endsWith("discard")).length);
        }
        finally {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
    }

    private void testQueue(@NotNull ChronicleQueue queue) {
        try (ExcerptTailer tailer = queue.createTailer();
             DocumentContext dc = tailer.readingDocument();){
            Assert.assertFalse((boolean)dc.isPresent());
        }
    }

    @Test
    public void testCompleteHeader() throws FileNotFoundException {
        this.ignoreException("reading control code as text");
        this.expectException("closable tracing disabled");
        this.expectException("Unexpected field lastAcknowledgedIndexReplicated");
        AbstractCloseable.disableCloseableTracing();
        File dir = this.getTmpDir();
        dir.mkdirs();
        File file = new File(dir, "19700101T4.cq4");
        this.testWritingTo((Bytes<?>)new HexDumpBytes());
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)file, (long)((long)QueueUtil.testBlockSize() * 2L));){
            this.testWritingTo((Bytes<?>)bytes);
        }
        var4_5 = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).testBlockSize().build();){
            this.testQueue((ChronicleQueue)queue);
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testWritingTo(Bytes<?> bytes) {
        try (SCQIndexing marshallable = new SCQIndexing(WireType.BINARY, 32, 4);){
            BinaryWire wire = new BinaryWire(bytes);
            wire.usePadding(true);
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().writeEventName((CharSequence)"header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                    w.write((CharSequence)"wireType").object((Object)WireType.BINARY);
                    w.write((CharSequence)"writePosition").int64forBinding(0L);
                    w.write((CharSequence)"roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)TestRollCycles.TEST4_DAILY, 0L, null, null));
                    w.write((CharSequence)"indexing").typedMarshallable((WriteMarshallable)marshallable);
                    w.write((CharSequence)"lastAcknowledgedIndexReplicated").int64forBinding(0L);
                });
            }
        }
        String expected = "00000000 24 01 00 40 b9 06 68 65  61 64 65 72 b6 08 53 43 $\u00b7\u00b7@\u00b7\u00b7he ader\u00b7\u00b7SC\n00000010 51 53 74 6f 72 65 82 0d  01 00 00 c8 77 69 72 65 QStore\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7wire\n00000020 54 79 70 65 b6 08 57 69  72 65 54 79 70 65 e6 42 Type\u00b7\u00b7Wi reType\u00b7B\n00000030 49 4e 41 52 59 cd 77 72  69 74 65 50 6f 73 69 74 INARY\u00b7wr itePosit\n00000040 69 6f 6e 8f 8f 8f 8f a7  00 00 00 00 00 00 00 00 ion\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n00000050 c4 72 6f 6c 6c b6 08 53  43 51 53 52 6f 6c 6c 82 \u00b7roll\u00b7\u00b7S CQSRoll\u00b7\n00000060 28 00 00 00 c6 6c 65 6e  67 74 68 a6 00 5c 26 05 (\u00b7\u00b7\u00b7\u00b7len gth\u00b7\u00b7\\&\u00b7\n00000070 c6 66 6f 72 6d 61 74 ec  79 79 79 79 4d 4d 64 64 \u00b7format\u00b7 yyyyMMdd\n00000080 27 54 34 27 c5 65 70 6f  63 68 a1 00 c8 69 6e 64 'T4'\u00b7epo ch\u00b7\u00b7\u00b7ind\n00000090 65 78 69 6e 67 b6 0c 53  43 51 53 49 6e 64 65 78 exing\u00b7\u00b7S CQSIndex\n000000a0 69 6e 67 82 50 00 00 00  ca 69 6e 64 65 78 43 6f ing\u00b7P\u00b7\u00b7\u00b7 \u00b7indexCo\n000000b0 75 6e 74 a1 20 cc 69 6e  64 65 78 53 70 61 63 69 unt\u00b7 \u00b7in dexSpaci\n000000c0 6e 67 a1 04 cb 69 6e 64  65 78 32 49 6e 64 65 78 ng\u00b7\u00b7\u00b7ind ex2Index\n000000d0 8e 02 00 00 00 00 00 a7  00 00 00 00 00 00 00 00 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n000000e0 c9 6c 61 73 74 49 6e 64  65 78 8e 00 00 00 00 a7 \u00b7lastInd ex\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n000000f0 00 00 00 00 00 00 00 00  df 6c 61 73 74 41 63 6b \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7lastAck\n00000100 6e 6f 77 6c 65 64 67 65  64 49 6e 64 65 78 52 65 nowledge dIndexRe\n00000110 70 6c 69 63 61 74 65 64  8e 02 00 00 00 00 00 a7 plicated \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n00000120 00 00 00 00 00 00 00 00                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n";
        String expectedHexDump = "24 01 00 40                                     # msg-length\nb9 06 68 65 61 64 65 72                         # header: (event)\nb6 08 53 43 51 53 74 6f 72 65                   # SCQStore\n82 0d 01 00 00                                  # SingleCQFormatTest$$Lambda\nc8 77 69 72 65 54 79 70 65                      # wireType:\nb6 08 57 69 72 65 54 79 70 65                   # WireType\ne6 42 49 4e 41 52 59                            # BINARY\ncd 77 72 69 74 65 50 6f 73 69 74 69 6f 6e       # writePosition:\n8f 8f 8f 8f                                     # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\nc4 72 6f 6c 6c                                  # roll:\nb6 08 53 43 51 53 52 6f 6c 6c                   # SCQSRoll\n82 28 00 00 00                                  # SCQRoll\nc6 6c 65 6e 67 74 68                            # length:\na6 00 5c 26 05                                  # 86400000\nc6 66 6f 72 6d 61 74                            # format:\nec 79 79 79 79 4d 4d 64 64 27 54 34 27          # yyyyMMdd'T4'\nc5 65 70 6f 63 68                               # epoch:\na1 00                                           # 0\nc8 69 6e 64 65 78 69 6e 67                      # indexing:\nb6 0c 53 43 51 53 49 6e 64 65 78 69 6e 67       # SCQSIndexing\n82 50 00 00 00                                  # SCQIndexing\nca 69 6e 64 65 78 43 6f 75 6e 74                # indexCount:\na1 20                                           # 32\ncc 69 6e 64 65 78 53 70 61 63 69 6e 67          # indexSpacing:\na1 04                                           # 4\ncb 69 6e 64 65 78 32 49 6e 64 65 78             # index2Index:\n                                                # int64 for binding\n8e 02 00 00 00 00 00                            # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\nc9 6c 61 73 74 49 6e 64 65 78                   # lastIndex:\n                                                # int64 for binding\n8e 00 00 00 00                                  # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\ndf 6c 61 73 74 41 63 6b 6e 6f 77 6c 65 64 67 65 # lastAcknowledgedIndexReplicated:\n64 49 6e 64 65 78 52 65 70 6c 69 63 61 74 65 64 # int64 for binding\n8e 02 00 00 00 00 00 a7 00 00 00 00 00 00 00 00 # 0\n";
        Assert.assertEquals((Object)(bytes instanceof HexDumpBytes ? "24 01 00 40                                     # msg-length\nb9 06 68 65 61 64 65 72                         # header: (event)\nb6 08 53 43 51 53 74 6f 72 65                   # SCQStore\n82 0d 01 00 00                                  # SingleCQFormatTest$$Lambda\nc8 77 69 72 65 54 79 70 65                      # wireType:\nb6 08 57 69 72 65 54 79 70 65                   # WireType\ne6 42 49 4e 41 52 59                            # BINARY\ncd 77 72 69 74 65 50 6f 73 69 74 69 6f 6e       # writePosition:\n8f 8f 8f 8f                                     # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\nc4 72 6f 6c 6c                                  # roll:\nb6 08 53 43 51 53 52 6f 6c 6c                   # SCQSRoll\n82 28 00 00 00                                  # SCQRoll\nc6 6c 65 6e 67 74 68                            # length:\na6 00 5c 26 05                                  # 86400000\nc6 66 6f 72 6d 61 74                            # format:\nec 79 79 79 79 4d 4d 64 64 27 54 34 27          # yyyyMMdd'T4'\nc5 65 70 6f 63 68                               # epoch:\na1 00                                           # 0\nc8 69 6e 64 65 78 69 6e 67                      # indexing:\nb6 0c 53 43 51 53 49 6e 64 65 78 69 6e 67       # SCQSIndexing\n82 50 00 00 00                                  # SCQIndexing\nca 69 6e 64 65 78 43 6f 75 6e 74                # indexCount:\na1 20                                           # 32\ncc 69 6e 64 65 78 53 70 61 63 69 6e 67          # indexSpacing:\na1 04                                           # 4\ncb 69 6e 64 65 78 32 49 6e 64 65 78             # index2Index:\n                                                # int64 for binding\n8e 02 00 00 00 00 00                            # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\nc9 6c 61 73 74 49 6e 64 65 78                   # lastIndex:\n                                                # int64 for binding\n8e 00 00 00 00                                  # int64 for binding\na7 00 00 00 00 00 00 00 00                      # 0\ndf 6c 61 73 74 41 63 6b 6e 6f 77 6c 65 64 67 65 # lastAcknowledgedIndexReplicated:\n64 49 6e 64 65 78 52 65 70 6c 69 63 61 74 65 64 # int64 for binding\n8e 02 00 00 00 00 00 a7 00 00 00 00 00 00 00 00 # 0\n" : "00000000 24 01 00 40 b9 06 68 65  61 64 65 72 b6 08 53 43 $\u00b7\u00b7@\u00b7\u00b7he ader\u00b7\u00b7SC\n00000010 51 53 74 6f 72 65 82 0d  01 00 00 c8 77 69 72 65 QStore\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7wire\n00000020 54 79 70 65 b6 08 57 69  72 65 54 79 70 65 e6 42 Type\u00b7\u00b7Wi reType\u00b7B\n00000030 49 4e 41 52 59 cd 77 72  69 74 65 50 6f 73 69 74 INARY\u00b7wr itePosit\n00000040 69 6f 6e 8f 8f 8f 8f a7  00 00 00 00 00 00 00 00 ion\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n00000050 c4 72 6f 6c 6c b6 08 53  43 51 53 52 6f 6c 6c 82 \u00b7roll\u00b7\u00b7S CQSRoll\u00b7\n00000060 28 00 00 00 c6 6c 65 6e  67 74 68 a6 00 5c 26 05 (\u00b7\u00b7\u00b7\u00b7len gth\u00b7\u00b7\\&\u00b7\n00000070 c6 66 6f 72 6d 61 74 ec  79 79 79 79 4d 4d 64 64 \u00b7format\u00b7 yyyyMMdd\n00000080 27 54 34 27 c5 65 70 6f  63 68 a1 00 c8 69 6e 64 'T4'\u00b7epo ch\u00b7\u00b7\u00b7ind\n00000090 65 78 69 6e 67 b6 0c 53  43 51 53 49 6e 64 65 78 exing\u00b7\u00b7S CQSIndex\n000000a0 69 6e 67 82 50 00 00 00  ca 69 6e 64 65 78 43 6f ing\u00b7P\u00b7\u00b7\u00b7 \u00b7indexCo\n000000b0 75 6e 74 a1 20 cc 69 6e  64 65 78 53 70 61 63 69 unt\u00b7 \u00b7in dexSpaci\n000000c0 6e 67 a1 04 cb 69 6e 64  65 78 32 49 6e 64 65 78 ng\u00b7\u00b7\u00b7ind ex2Index\n000000d0 8e 02 00 00 00 00 00 a7  00 00 00 00 00 00 00 00 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n000000e0 c9 6c 61 73 74 49 6e 64  65 78 8e 00 00 00 00 a7 \u00b7lastInd ex\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n000000f0 00 00 00 00 00 00 00 00  df 6c 61 73 74 41 63 6b \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 \u00b7lastAck\n00000100 6e 6f 77 6c 65 64 67 65  64 49 6e 64 65 78 52 65 nowledge dIndexRe\n00000110 70 6c 69 63 61 74 65 64  8e 02 00 00 00 00 00 a7 plicated \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\n00000120 00 00 00 00 00 00 00 00                          \u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7         \n"), (Object)bytes.toHexString().replaceAll("Lambda.*", "Lambda"));
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 0,\n  roll: !SCQSRoll {\n    length: 86400000,\n    format: yyyyMMdd'T4',\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: 32,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)((Bytes)bytes.readPosition(0L))));
    }

    @Test
    public void testCompleteHeader2() throws FileNotFoundException {
        File dir = new File(OS.getTarget(), this.getClass().getSimpleName() + "-" + Time.uniqueId());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101-02.cq4"), (long)((long)QueueUtil.testBlockSize() * 2L));
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        wire.usePadding(true);
        try (SingleChronicleQueueStore store = new SingleChronicleQueueStore((RollCycle)LegacyRollCycles.HOURLY, WireType.BINARY, bytes, 4096, 4);){
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().write((CharSequence)"header").typedMarshallable((WriteMarshallable)store);
            }
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    0,\n    0\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: !short 4096,\n    indexSpacing: 4,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  dataFormat: 1\n}\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        }
        var5_6 = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().rollCycle((RollCycle)LegacyRollCycles.HOURLY).build();){
            this.testQueue((ChronicleQueue)queue);
            Assert.assertEquals((long)2L, (long)queue.firstCycle());
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncompleteHeader() throws FileNotFoundException {
        File dir = new File(OS.getTarget(), this.getClass().getSimpleName() + "-" + Time.uniqueId());
        dir.mkdir();
        try (MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101T4.cq4"), (long)QueueUtil.testBlockSize());){
            BinaryWire wire = new BinaryWire((Bytes)bytes);
            wire.usePadding(true);
            try (DocumentContext dc = wire.writingDocument(true);){
                dc.wire().writeEventName((CharSequence)"header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> w.write((CharSequence)"wireType").object((Object)WireType.BINARY));
            }
        }
        try {
            var3_5 = null;
            try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).rollCycle((RollCycle)TestRollCycles.TEST4_DAILY).blockSize(QueueUtil.testBlockSize()).build();){
                this.testQueue((ChronicleQueue)queue);
                Assert.fail();
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"net.openhft.chronicle.core.io.IORuntimeException: net.openhft.chronicle.core.io.IORuntimeException: field writePosition required", (Object)e.toString());
        }
        System.gc();
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SingleChronicleQueueBuilder.addAliases();
    }
}

