/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Ignore;
import org.junit.Test;

public class CheckIndicesTest
extends QueueTestCommon {
    private static final int BATCH_SIZE = 10;
    private ChronicleQueue queue0;

    @Ignore(value="stress test to run manually")
    @Test
    public void test() throws ExecutionException, InterruptedException {
        SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).epoch(System.currentTimeMillis()).build();
        Throwable throwable = null;
        try {
            try {
                this.queue0 = queue;
                Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this::appendToQueue, 0L, 1L, TimeUnit.MICROSECONDS);
                Future<Callable> f = Executors.newSingleThreadScheduledExecutor().submit(this::checkIndices);
                Future<Callable> f2 = Executors.newSingleThreadScheduledExecutor().submit(this::checkIndices);
                while (true) {
                    if (f.isDone()) {
                        f.get();
                    }
                    if (f2.isDone()) {
                        f2.get();
                    }
                    Thread.sleep(500L);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (queue != null) {
                if (throwable != null) {
                    try {
                        queue.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    queue.close();
                }
            }
            throw throwable3;
        }
    }

    private Callable<Void> checkIndices() {
        ExcerptTailer tailer = this.queue0.createTailer();
        long index = 0L;
        boolean movetoIndex = true;
        for (int i = 0; i < 10000000; ++i) {
            if (movetoIndex && !tailer.moveToIndex(index)) continue;
            try (DocumentContext dc = tailer.readingDocument();){
                if (!dc.isPresent()) {
                    index += (long)(Math.random() * 10.0) - 2L;
                    movetoIndex = true;
                    continue;
                }
                if (index != dc.index()) {
                    throw new AssertionError();
                }
                if (this.queue0.rollCycle().toSequenceNumber(index) != dc.wire().read("value").readLong()) {
                    throw new AssertionError();
                }
            }
            movetoIndex = false;
            ++index;
        }
        return null;
    }

    private void appendToQueue() {
        try (ExcerptAppender appender = this.queue0.createAppender();){
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    long seq = appender.queue().rollCycle().toSequenceNumber(dc.index());
                    dc.wire().write((CharSequence)"value").writeLong(seq);
                    continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

