/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.bench.BenchmarkUtils;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;

public class QueueSparseFilesJLBHBenchmark
implements JLBHTask {
    private static final int throughput = Integer.getInteger("throughput", 10000);
    private static final int runTime = Integer.getInteger("runTime", 30);
    private static final long iterations = (long)throughput * (long)runTime;
    private final int round;
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private JLBH jlbh;
    private NanoSampler writeProbe;
    private NanoSampler readProbe;
    private boolean stopped = false;
    private Thread tailerThread;
    private static final long CHUNKSIZE = 4096L;
    private static final int WARMUP = 200000;
    private static final int WRITE_CPU = 8;
    private static final int READ_CPU = 9;
    private static final int RUNS = 5;
    private static final long SPARSEBLOCK = 0x10000000000L;
    private static final long NORMALBLOCK = 0x4000000L;
    private static final String ROOTDIR = "/mnt/local/benchmark/";

    public QueueSparseFilesJLBHBenchmark(int round) {
        this.round = round;
    }

    public static void main(String ... args) {
        System.out.println("-Dthroughput=" + throughput + " -DrunTime=" + runTime);
        for (int round = 1; round <= 3; ++round) {
            System.out.println("========\nround= " + round + "\n========\n");
            JLBHOptions lth = new JLBHOptions().warmUpIterations(200000).iterations(iterations).throughput(throughput).recordOSJitter(false).skipFirstRun(true).acquireLock(() -> AffinityLock.acquireLock((int)8)).runs(5).jlbhTask((JLBHTask)new QueueSparseFilesJLBHBenchmark(round));
            new JLBH(lth).start();
        }
    }

    public void init(JLBH jlbh) {
        IOTools.deleteDirWithFiles((String)ROOTDIR, (int)5);
        if (this.round == 1) {
            this.sourceQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/sparseFile").useSparseFiles(true).sparseCapacity(0x10000000000L).build();
            this.sinkQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/sparseFile").useSparseFiles(true).sparseCapacity(0x10000000000L).build();
        } else if (this.round == 2) {
            this.sourceQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/chunking-largeBlockSize").blockSize(0x10000000000L).build();
            this.sinkQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/chunking-largeBlockSize").blockSize(0x10000000000L).build();
        } else {
            this.sourceQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/chunking-standardBlockSize").blockSize(0x4000000L).build();
            this.sinkQueue = SingleChronicleQueueBuilder.single((String)"/mnt/local/benchmark/chunking-standardBlockSize").blockSize(0x4000000L).build();
        }
        this.appender = this.sourceQueue.createAppender();
        this.appender.singleThreadedCheckDisabled(true);
        this.tailer = this.sinkQueue.createTailer();
        this.tailer.singleThreadedCheckDisabled(true);
        this.jlbh = jlbh;
        NanoSampler nanoSampler = this.round == 1 ? jlbh.addProbe("write (sparse file)") : (this.writeProbe = this.round == 2 ? jlbh.addProbe("write (chunking-largeBlockSize)") : jlbh.addProbe("write (chunking-standardBlockSize)"));
        this.readProbe = this.round == 1 ? jlbh.addProbe("read (sparse file)") : (this.round == 2 ? jlbh.addProbe("read (chunking-largeBlockSize)") : jlbh.addProbe("read (chunking-standardBlockSize)"));
        this.tailerThread = new Thread(() -> {
            try (AffinityLock affinityLock = AffinityLock.acquireLock((int)9);){
                Throwable throwable;
                DocumentContext dc;
                while (!this.stopped) {
                    block27: {
                        long beforeReadNS;
                        block25: {
                            block26: {
                                beforeReadNS = System.nanoTime();
                                dc = this.tailer.readingDocument();
                                throwable = null;
                                if (dc.isPresent()) break block25;
                                if (dc == null) continue;
                                if (throwable == null) break block26;
                                try {
                                    dc.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                continue;
                            }
                            dc.close();
                            continue;
                        }
                        Bytes bytes = dc.wire().bytes();
                        bytes.readSkip(4096L);
                        long writeNS = bytes.readLong();
                        long now = System.nanoTime();
                        jlbh.sample(now - writeNS);
                        this.readProbe.sampleNanos(now - beforeReadNS);
                        if (dc == null) continue;
                        if (throwable == null) break block27;
                        try {
                            dc.close();
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            continue;
                        }
                    }
                    dc.close();
                }
                return;
                catch (Throwable throwable4) {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (dc == null) throw throwable5;
                        if (throwable != null) {
                            try {
                                dc.close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                        dc.close();
                        throw throwable5;
                    }
                }
            }
        });
        this.tailerThread.start();
    }

    public void run(long startTimeNS) {
        try (DocumentContext dc = this.appender.writingDocument();){
            Bytes bytes = dc.wire().bytes();
            bytes.writeSkip(4096L);
            bytes.writeLong(System.nanoTime());
        }
        this.writeProbe.sampleNanos(System.nanoTime() - startTimeNS);
    }

    public void complete() {
        this.stopped = true;
        BenchmarkUtils.join(this.tailerThread);
        this.sinkQueue.close();
        this.sourceQueue.close();
        IOTools.deleteDirWithFiles((String)ROOTDIR, (int)5);
    }

    static {
        System.setProperty("disable.thread.safety", "true");
        System.setProperty("jvm.resource.tracing", "false");
        System.setProperty("check.thread.safety", "false");
    }
}

