/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Test;

public class VisibilityOfMessagesBetweenTailorsAndAppenderTest
extends QueueTestCommon {
    volatile long lastWrittenIndex = Long.MIN_VALUE;

    @Test
    public void test() throws InterruptedException, ExecutionException {
        try (SingleChronicleQueue x = SingleChronicleQueueBuilder.binary((File)this.getTmpDir()).rollCycle((RollCycle)LegacyRollCycles.MINUTELY).build();){
            ExecutorService e1 = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("e1"));
            e1.submit(() -> this.lambda$test$0((ChronicleQueue)x));
            ExecutorService e2 = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("e2"));
            Future<Void> f2 = e2.submit(() -> this.lambda$test$1((ChronicleQueue)x));
            try {
                f2.get(Jvm.isCodeCoverage() ? 20L : 5L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            e1.shutdown();
            e2.shutdown();
            if (!e1.awaitTermination(1L, TimeUnit.SECONDS)) {
                e1.shutdownNow();
            }
            if (!e2.awaitTermination(1L, TimeUnit.SECONDS)) {
                e2.shutdownNow();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ Void lambda$test$1(ChronicleQueue x) throws Exception {
        try (ExcerptTailer tailer = x.createTailer();){
            while (true) {
                long i;
                if ((i = this.lastWrittenIndex) != Long.MIN_VALUE && !tailer.moveToIndex(i)) {
                    throw new ExecutionException("non atomic, index=" + Long.toHexString(i), null);
                }
                if (Thread.currentThread().isInterrupted()) {
                    Void void_ = null;
                    return void_;
                }
                continue;
                break;
            }
        }
    }

    private /* synthetic */ Object lambda$test$0(ChronicleQueue x) throws Exception {
        try (ExcerptAppender excerptAppender = x.createAppender();){
            for (long i = 0L; i < 1000000L; ++i) {
                try (DocumentContext dc = excerptAppender.writingDocument();){
                    dc.wire().getValueOut().int64(i);
                }
                this.lastWrittenIndex = excerptAppender.lastIndexAppended();
                if (!Thread.currentThread().isInterrupted()) continue;
                Object var6_7 = null;
                return var6_7;
            }
        }
        return null;
    }
}

