/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class ReadWriteTest
extends QueueTestCommon {
    private static final String STR1 = "hello";
    private static final String STR2 = "hey";
    private File chroniclePath;

    @Before
    public void setup() {
        this.chroniclePath = this.getTmpDir();
        try (SingleChronicleQueue readWrite = ChronicleQueue.singleBuilder((File)this.chroniclePath).readOnly(false).testBlockSize().build();
             ExcerptAppender appender = readWrite.createAppender();){
            appender.writeText((CharSequence)STR1);
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().bytes().writeUtf8(STR2);
            }
        }
    }

    @Test
    public void testReadFromReadOnlyChronicle() {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            Assert.assertTrue((out.dump().length() > 1 ? 1 : 0) != 0);
            ExcerptTailer tailer = out.createTailer();
            Assert.assertEquals((Object)STR1, (Object)tailer.readText());
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertEquals((Object)STR2, (Object)dc.wire().bytes().readUtf8());
            }
        }
    }

    @Test
    public void testNotInitializedMetadataFile() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        String expectedException = "Failback to readonly tablestore";
        this.expectException("Failback to readonly tablestore");
        System.out.println("This test will produce a Failback to readonly tablestore");
        File meta = new File(this.chroniclePath, "metadata.cq4t");
        Assert.assertTrue((boolean)meta.exists());
        try (RandomAccessFile raf = new RandomAccessFile(meta, "rw");){
            raf.setLength(0L);
        }
        var4_4 = null;
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testProceedWhenMetadataFileInitialized() throws IOException {
        Assume.assumeFalse((boolean)OS.isWindows());
        File meta = new File(this.chroniclePath, "metadata.cq4t");
        Assert.assertTrue((boolean)meta.exists());
        try (RandomAccessFile raf = new RandomAccessFile(meta, "rw");){
            raf.setLength(0L);
        }
        AtomicLong startTimeMillis = new AtomicLong();
        new Thread(() -> {
            startTimeMillis.set(System.currentTimeMillis());
            Jvm.pause((long)200L);
            SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().build();
            Throwable throwable = null;
            if (out != null) {
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    out.close();
                }
            }
        }).start();
        this.ignoreException("Discarded without closing");
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            Assert.assertTrue((String)("Should have waited for more than 200ms. Actual wait: " + (System.currentTimeMillis() - startTimeMillis.get()) + " ms"), (System.currentTimeMillis() - startTimeMillis.get() >= 200L ? 1 : 0) != 0);
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testWriteToReadOnlyChronicle() {
        if (OS.isWindows()) {
            System.err.println("#460 Cannot test read only mode on windows");
            throw new IllegalStateException("not run");
        }
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptAppender appender = out.createAppender();
            Throwable throwable = null;
            if (appender != null) {
                if (throwable != null) {
                    try {
                        appender.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    appender.close();
                }
            }
        }
    }

    @Test
    public void testToEndOnReadOnly() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(true).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
    }

    @Test
    public void testNonWriteableFilesSetToReadOnly() {
        Assume.assumeFalse((boolean)OS.isWindows());
        this.expectException("Failback to readonly tablestore");
        this.expectException("Forcing queue to be readOnly");
        Arrays.stream(this.chroniclePath.list()).forEach(s -> Assert.assertTrue((boolean)new File(this.chroniclePath, (String)s).setWritable(false)));
        try (SingleChronicleQueue out = SingleChronicleQueueBuilder.binary((File)this.chroniclePath).testBlockSize().readOnly(false).build();){
            ExcerptTailer tailer = out.createTailer();
            tailer.toEnd();
            long index = tailer.index();
            Assert.assertNotEquals((long)0L, (long)index);
        }
    }
}

