/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.internal.JvmExceptionTracker;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;
import net.openhft.chronicle.wire.MessageHistory;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class QueueTestCommon {
    private static final boolean TRACE_TEST_EXECUTION = Jvm.getBoolean((String)"queue.traceTestExecution");
    private final List<File> tmpDirs = new ArrayList<File>();
    protected ThreadDump threadDump;
    protected boolean finishedNormally;
    protected ExceptionTracker<ExceptionKey> exceptionTracker;
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final ErrorCollector errorCollector = new ErrorCollector();
    @Rule
    @NotNull
    public TestRule watcher = new TestWatcher(){

        protected void starting(@NotNull Description description) {
            if (TRACE_TEST_EXECUTION) {
                Jvm.debug().on(((Object)((Object)this)).getClass(), "Starting test: " + description.getClassName() + "." + description.getMethodName());
            }
        }
    };
    static AtomicLong counter;

    @NotNull
    protected File getTmpDir() {
        String methodName = this.testName.getMethodName();
        String name = methodName == null ? "unknown" : methodName;
        File tmpDir = DirectoryUtils.tempDir(name + "-" + counter.incrementAndGet());
        this.tmpDirs.add(tmpDir);
        return tmpDir;
    }

    @Before
    public void assumeFinishedNormally() {
        this.finishedNormally = true;
    }

    @Before
    public void clearMessageHistory() {
        MessageHistory.get().reset();
    }

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptionTracker = JvmExceptionTracker.create((boolean)false);
        if (OS.isWindows()) {
            this.ignoreException("Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write");
        }
        for (String msg : "Shrinking ,Allocation of , ms to add mapping for ,jar to the classpath, ms to pollDiskSpace for , us to linearScan by position from ,File released ,Overriding roll length from existing metadata, was 3600000, overriding to 86400000   ".split(",")) {
            this.ignoreException(msg);
        }
    }

    public void ignoreException(String message) {
        this.exceptionTracker.ignoreException(message);
    }

    public void expectException(String message) {
        this.exceptionTracker.expectException(message);
    }

    public void ignoreException(Predicate<ExceptionKey> predicate, String description) {
        this.exceptionTracker.ignoreException(predicate, description);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.exceptionTracker.expectException(predicate, description);
    }

    public void checkExceptions() {
        this.exceptionTracker.checkExceptions();
    }

    @After
    public void afterChecks() {
        this.preAfter();
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        AbstractCloseable.gcAndWaitForCloseablesToClose();
        if (this.finishedNormally) {
            this.assertReferencesReleased();
            this.checkThreadDump();
            this.checkExceptions();
        }
        this.tearDown();
    }

    protected void preAfter() {
    }

    protected void tearDown() {
        this.tmpDirs.forEach(file -> {
            if (file.exists() && !IOTools.deleteDirWithFiles((File)file)) {
                Jvm.error().on(this.getClass(), "Could not delete tmp dir " + file);
            }
        });
    }

    static {
        System.setProperty("queue.check.index", "true");
        counter = new AtomicLong();
    }
}

