/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.threads.Threads;
import org.junit.Assert;
import org.junit.Test;

public class MoveToCycleMultiThreadedStressTest
extends ChronicleQueueTestBase {
    private ThreadLocal<ExcerptTailer> tailer;
    private final AtomicLong last = new AtomicLong();
    private long firstCycle;
    private static final int READ_THREADS = 10;
    private ChronicleQueue queue;
    private AtomicBoolean shutDown = new AtomicBoolean();

    @Test(timeout=60000L)
    public void test() throws ExecutionException, InterruptedException {
        String path = OS.getTarget() + "/stressMoveToCycle-" + Time.uniqueId();
        ExecutorService es = Executors.newCachedThreadPool();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((String)path).testBlockSize().rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            this.queue = q;
            this.tailer = ThreadLocal.withInitial(() -> ((ChronicleQueue)q).createTailer());
            ExcerptAppender excerptAppender = q.acquireAppender();
            excerptAppender.writeText((CharSequence)"first");
            this.updateLast(excerptAppender);
            this.firstCycle = excerptAppender.queue().rollCycle().toCycle(q.firstIndex());
            Future<Void> appender = es.submit(this::append);
            ArrayList<Future<Void>> f = new ArrayList<Future<Void>>();
            for (int i = 0; i < 10; ++i) {
                f.add(es.submit(this::randomMove));
            }
            appender.get();
            this.shutDown.set(true);
            Thread.sleep(100L);
            f.forEach(c -> {
                try {
                    c.get(1L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            });
        }
        Threads.shutdown((ExecutorService)es);
    }

    private Void append() {
        ExcerptAppender excerptAppender = this.queue.acquireAppender();
        for (int i = 0; i < 50; ++i) {
            excerptAppender.writeText((CharSequence)"hello");
            this.updateLast(excerptAppender);
            Jvm.pause((long)100L);
        }
        return null;
    }

    private void updateLast(ExcerptAppender excerptAppender) {
        long expect;
        long lastIndex = excerptAppender.lastIndexAppended();
        long lastCycle = excerptAppender.queue().rollCycle().toCycle(lastIndex);
        while (!this.last.compareAndSet(expect = this.last.get(), lastCycle)) {
        }
    }

    private Void randomMove() {
        ExcerptTailer tailer = this.tailer.get();
        while (!this.shutDown.get()) {
            long span = this.last.get() - this.firstCycle;
            int cycle = (int)(Math.random() * (double)span + (double)this.firstCycle);
            tailer.moveToCycle(cycle);
        }
        tailer.close();
        return null;
    }
}

