/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.BytesInBinaryMarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class DtoBytesMarshallableTest
extends QueueTestCommon {
    @Test
    public void testDtoBytesMarshallable() {
        File tmp = this.getTmpDir();
        DtoBytesMarshallable dto = new DtoBytesMarshallable();
        dto.age = 45;
        dto.name.append("rob");
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((File)tmp).build();
             ExcerptAppender appender = q.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"who").object((Object)dto);
            }
            dc = q.createTailer().readingDocument();
            var8_12 = null;
            try {
                DtoBytesMarshallable who = (DtoBytesMarshallable)((Object)dc.wire().read("who").object());
                Assert.assertEquals((Object)"!net.openhft.chronicle.queue.DtoBytesMarshallableTest$DtoBytesMarshallable {\n  name: rob,\n  age: 45\n}\n", (Object)who.toString());
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    @Test
    public void testDtoAbstractMarshallable() {
        File tmp = this.getTmpDir();
        DtoAbstractMarshallable dto = new DtoAbstractMarshallable();
        dto.age = 45;
        dto.name.append("rob");
        try (SingleChronicleQueue q = ChronicleQueue.singleBuilder((File)tmp).build();
             ExcerptAppender appender = q.createAppender();){
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"who").object((Object)dto);
            }
            dc = q.createTailer().readingDocument();
            var8_12 = null;
            try {
                String yaml = dc.toString();
                DtoAbstractMarshallable who = (DtoAbstractMarshallable)((Object)dc.wire().read("who").object());
                Assert.assertTrue((boolean)yaml.contains(who.toString()));
            }
            catch (Throwable throwable) {
                var8_12 = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (var8_12 != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            var8_12.addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
        }
    }

    public static class DtoAbstractMarshallable
    extends SelfDescribingMarshallable {
        StringBuilder name = new StringBuilder();
        int age;

        public void readMarshallable(BytesIn<?> bytes) {
            this.age = bytes.readInt();
            this.name.setLength(0);
            bytes.readUtf8(this.name);
        }

        public void writeMarshallable(BytesOut<?> bytes) {
            bytes.writeInt(this.age);
            bytes.writeUtf8((CharSequence)this.name);
        }
    }

    public static class DtoBytesMarshallable
    extends BytesInBinaryMarshallable {
        StringBuilder name = new StringBuilder();
        int age;

        public void readMarshallable(BytesIn<?> bytes) {
            this.age = bytes.readInt();
            this.name.setLength(0);
            bytes.readUtf8(this.name);
        }

        public void writeMarshallable(BytesOut<?> bytes) {
            bytes.writeInt(this.age);
            bytes.writeUtf8((CharSequence)this.name);
        }
    }
}

