/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@Ignore(value="long running")
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ContendedWriterTest
extends QueueTestCommon {
    private static final long NUMBER_OF_LONGS = 3L;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private ThreadDump threadDump;

    @Test
    public void oneThread() {
        this.test("oneThread", new Config(false, 1, 0));
    }

    @Test
    public void oneThreadDeferred() {
        this.test("oneThreadDeferred", new Config(true, 1, 0));
    }

    @Test
    public void sixThreads() {
        Config config15 = new Config(false, 1, 5);
        this.test("sixThreads", config15, config15, config15, config15, config15, config15);
    }

    @Test
    public void sixThreadsDeferred() {
        Config config15 = new Config(true, 1, 5);
        this.test("sixThreadsDeferred", config15, config15, config15, config15, config15, config15);
    }

    @Test
    public void twoThreadsWritingLargeMessagesAtSameSlowRate() {
        this.test("twoThreadsWritingLargeMessagesAtSameSlowRate", new Config(false, 1, 5), new Config(false, 1, 5));
    }

    @Test
    public void twoThreadsWritingLargeMessagesAtSameSlowRateBothDeferred() {
        this.test("twoThreadsWritingLargeMessagesAtSameSlowRateBothDeferred", new Config(true, 1, 5), new Config(true, 1, 5));
    }

    @Test
    public void twoThreadsWritingLargeMessagesOneFastOneSlow() {
        this.test("twoThreadsWritingLargeMessagesOneFastOneSlow", new Config(false, 1, 0), new Config(false, 1, 5));
    }

    @Test
    public void twoThreadsWritingLargeMessagesOneFastOneSlowAndDeferred() {
        this.test("twoThreadsWritingLargeMessagesOneFastOneSlowAndDeferred", new Config(false, 1, 0), new Config(true, 1, 5));
    }

    @Test
    public void twoThreadsWritingLargeMessagesFastAndSmallMessagesSlow() {
        this.test("twoThreadsWritingLargeMessagesFastAndSmallMessagesSlow", new Config(false, 1, 0), new Config(false, 0, 5));
    }

    @Test
    public void twoThreadsWritingLargeMessagesFastAndSmallMessagesSlowAndDeferred() {
        this.test("twoThreadsWritingLargeMessagesFastAndSmallMessagesSlowAndDeferred", new Config(false, 1, 0), new Config(true, 0, 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(String name, Config ... configs) {
        File path = this.getTmpDir();
        Object[] queues = new SingleChronicleQueue[configs.length];
        StartAndMonitor[] startAndMonitors = new StartAndMonitor[configs.length];
        try {
            int i;
            for (i = 0; i < configs.length; ++i) {
                queues[i] = SingleChronicleQueueBuilder.binary((File)path).testBlockSize().build();
                startAndMonitors[i] = new StartAndMonitor((ChronicleQueue)queues[i], Integer.toString(i), configs[i].writePause, configs[i].pauseBetweenWrites);
            }
            Jvm.pause((long)5000L);
            this.running.set(false);
            Jvm.pause((long)50L);
            this.running.set(true);
            for (i = 0; i < configs.length; ++i) {
                startAndMonitors[i] = new StartAndMonitor((ChronicleQueue)queues[i], Integer.toString(i), configs[i].writePause, configs[i].pauseBetweenWrites);
            }
            Jvm.pause((long)(Jvm.isDebug() ? 30000L : 15000L));
            this.running.set(false);
            Jvm.pause((long)50L);
            for (i = 0; i < configs.length; ++i) {
                System.out.println("thread" + i + " progress=" + configs[i].progressOnContention + " writePause=" + configs[i].writePause + " between=" + configs[i].pauseBetweenWrites + ": " + startAndMonitors[i].histo.toMicrosFormat());
            }
        }
        finally {
            Closeable.closeQuietly((Object[])queues);
        }
    }

    private class StartAndMonitor {
        Histogram histo = new Histogram();

        public StartAndMonitor(ChronicleQueue queue, String name, int writePauseMs, int sleepBetweenMillis) {
            SlowToSerialiseAndDeserialise object = new SlowToSerialiseAndDeserialise(writePauseMs);
            Thread thread = new Thread(() -> {
                try (ExcerptAppender appender = queue.createAppender();){
                    while (ContendedWriterTest.this.running.get()) {
                        long loopStart = System.nanoTime();
                        try (DocumentContext ctx = appender.writingDocument();){
                            ctx.wire().getValueOut().marshallable((WriteMarshallable)object);
                        }
                        long timeTaken = System.nanoTime() - loopStart;
                        this.histo.sampleNanos(timeTaken);
                        Jvm.pause((long)sleepBetweenMillis);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }, name);
            thread.start();
        }
    }

    private static class SlowToSerialiseAndDeserialise
    implements Marshallable {
        private final StringBuilder sb = new StringBuilder();
        private final long writePauseMs;

        private SlowToSerialiseAndDeserialise(long writePauseMs) {
            this.writePauseMs = writePauseMs;
        }

        public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
            ValueIn valueIn = wire.getValueIn();
            int i = 0;
            while ((long)i < 3L) {
                Assert.assertEquals((long)i, (long)valueIn.int64());
                ++i;
            }
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            ValueOut valueOut = wire.getValueOut();
            int i = 0;
            while ((long)i < 3L) {
                valueOut.int64((long)i);
                ++i;
            }
            Jvm.pause((long)this.writePauseMs);
        }
    }

    private static class Config {
        final boolean progressOnContention;
        final int writePause;
        final int pauseBetweenWrites;

        private Config(boolean progressOnContention, int writePause, int pauseBetweenWrites) {
            this.progressOnContention = progressOnContention;
            this.writePause = writePause;
            this.pauseBetweenWrites = pauseBetweenWrites;
        }
    }
}

