/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.utils.MethodReaderStatus;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGeneratedMethodReader
implements MethodReader {
    private static final Consumer<MessageHistory> NO_OP_MH_CONSUMER = Mocker.ignored(Consumer.class, new Class[0]);
    private static final MessageHistoryThreadLocal TEMP_MESSAGE_HISTORY = new MessageHistoryThreadLocal();
    protected final WireParselet debugLoggingParselet;
    private final MarshallableIn in;
    protected MessageHistory messageHistory;
    protected boolean dataEventProcessed;
    private boolean closeIn = false;
    private boolean closed;
    private Consumer<MessageHistory> historyConsumer = NO_OP_MH_CONSUMER;
    private Predicate predicate;
    private boolean scanning;

    protected AbstractGeneratedMethodReader(MarshallableIn in, WireParselet debugLoggingParselet) {
        this.in = in;
        this.debugLoggingParselet = debugLoggingParselet;
    }

    public AbstractGeneratedMethodReader predicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    protected static Method lookupMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getMethod(name, parameterTypes);
            Jvm.setAccessible(method);
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void historyConsumer(Consumer<MessageHistory> historyConsumer) {
        this.historyConsumer = historyConsumer;
    }

    protected MethodReaderStatus readOneGenerated(WireIn wireIn) {
        this.readOneCall(wireIn);
        return MethodReaderStatus.KNOWN;
    }

    @Deprecated
    protected boolean readOneCall(WireIn wireIn) {
        this.readOneGenerated(wireIn);
        return true;
    }

    protected MethodReaderStatus readOneMetaGenerated(WireIn wireIn) {
        this.readOneCallMeta(wireIn);
        return MethodReaderStatus.KNOWN;
    }

    @Deprecated
    protected boolean readOneCallMeta(WireIn wireIn) {
        this.readOneMetaGenerated(wireIn);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodReaderStatus readOne0(DocumentContext context) {
        Wire wireIn = context.wire();
        if (wireIn == null) {
            return MethodReaderStatus.EMPTY;
        }
        if (this.historyConsumer != NO_OP_MH_CONSUMER) {
            this.writeUnwrittenMessageHistory(context);
            this.messageHistory = null;
        }
        this.messageHistory().reset(context.sourceId(), context.index());
        try {
            wireIn.startEvent();
            wireIn.consumePadding();
            Bytes<?> bytes = wireIn.bytes();
            this.dataEventProcessed = false;
            MethodReaderStatus decoded = MethodReaderStatus.EMPTY;
            while (bytes.readRemaining() > 0L && !wireIn.isEndEvent()) {
                long start = bytes.readPosition();
                MethodReaderStatus mrs = context.isData() ? this.readOneGenerated(wireIn) : this.readOneMetaGenerated(wireIn);
                switch (mrs) {
                    case HISTORY: {
                        break;
                    }
                    case KNOWN: {
                        decoded = MethodReaderStatus.KNOWN;
                        break;
                    }
                    case UNKNOWN: {
                        if (decoded != MethodReaderStatus.EMPTY) break;
                        decoded = MethodReaderStatus.UNKNOWN;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)mrs);
                    }
                }
                if (this.restIgnored()) {
                    MethodReaderStatus methodReaderStatus = decoded;
                    return methodReaderStatus;
                }
                wireIn.consumePadding();
                if (bytes.readPosition() != start) continue;
                this.logNonProgressWarning(bytes.readRemaining());
                MethodReaderStatus methodReaderStatus = decoded;
                return methodReaderStatus;
            }
            wireIn.endEvent();
            MethodReaderStatus methodReaderStatus = decoded;
            return methodReaderStatus;
        }
        finally {
            if (this.historyConsumer != NO_OP_MH_CONSUMER && this.dataEventProcessed) {
                this.swapMessageHistoryIfDirty();
            }
            this.messageHistory.reset();
        }
    }

    private void logNonProgressWarning(long bytes) {
        Jvm.warn().on(this.getClass(), "Failed to progress reading " + bytes + " bytes left.");
    }

    protected boolean restIgnored() {
        return false;
    }

    private void swapMessageHistoryIfDirty() {
        if (this.messageHistory.isDirty()) {
            this.messageHistory = AbstractGeneratedMethodReader.TEMP_MESSAGE_HISTORY.getAndSet(this.messageHistory);
            MessageHistory.set(this.messageHistory);
            assert (this.messageHistory != TEMP_MESSAGE_HISTORY.get());
        } else {
            TEMP_MESSAGE_HISTORY.get().reset();
        }
    }

    private void writeUnwrittenMessageHistory(DocumentContext context) {
        MessageHistory mh = TEMP_MESSAGE_HISTORY.get();
        if (mh.sources() != 0 && context.sourceId() != mh.lastSourceId() && mh.isDirty()) {
            this.historyConsumer.accept(mh);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean readOne() {
        if (!this.predicate.test(this)) {
            return false;
        }
        block22: do {
            this.throwExceptionIfClosed();
            context = this.in.readingDocument();
            var2_2 = null;
            try {
                if (!context.isPresent()) break;
                mrs = this.readOne0(context);
                switch (1.$SwitchMap$net$openhft$chronicle$wire$utils$MethodReaderStatus[mrs.ordinal()]) {
                    case 2: {
                        if (this.scanning && context.isMetaData()) {
                            ** break;
lbl14:
                            // 1 sources

                            continue block22;
                        }
                        var4_7 = true;
                        return var4_7;
                    }
                    case 3: 
                    case 4: {
                        if (this.scanning) {
                            ** break;
lbl20:
                            // 1 sources

                            continue block22;
                        }
                        var4_8 = true;
                        return var4_8;
                    }
                    default: {
                        throw new AssertionError((Object)mrs);
                    }
                }
            }
            catch (Throwable var3_6) {
                var2_2 = var3_6;
                throw var3_6;
            }
            finally {
                if (context != null) {
                    if (var2_2 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable var3_4) {
                            var2_2.addSuppressed(var3_4);
                        }
                    } else {
                        context.close();
                    }
                }
            }
        } while (this.scanning);
        return false;
    }

    public void throwExceptionIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
    }

    @Override
    public MethodReaderInterceptorReturns methodReaderInterceptorReturns() {
        return null;
    }

    @Override
    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MethodReader closeIn(boolean closeIn) {
        this.throwExceptionIfClosed();
        this.closeIn = closeIn;
        return this;
    }

    protected <T> T checkRecycle(T o) {
        if (o == null || o.getClass().isArray()) {
            return null;
        }
        if (o instanceof Collection) {
            ((Collection)o).clear();
        }
        if (o instanceof Map) {
            ((Map)o).clear();
        }
        return o;
    }

    protected Object actualInvoke(Method method, Object o, Object[] objects) {
        try {
            return method.invoke(o, objects);
        }
        catch (Exception e) {
            throw Jvm.rethrow(e);
        }
    }

    private MessageHistory messageHistory() {
        if (this.messageHistory == null) {
            this.messageHistory = MessageHistory.get();
        }
        return this.messageHistory;
    }

    public void scanning(boolean scanning) {
        this.scanning = scanning;
    }

    private static final class MessageHistoryThreadLocal {
        private final ThreadLocal<MessageHistory> messageHistoryTL = ThreadLocal.withInitial(() -> {
            @NotNull VanillaMessageHistory veh = new VanillaMessageHistory();
            veh.addSourceDetails(true);
            return veh;
        });

        private MessageHistoryThreadLocal() {
        }

        private MessageHistory getAndSet(MessageHistory mh) {
            MessageHistory result = this.messageHistoryTL.get();
            this.messageHistoryTL.set(mh);
            return result;
        }

        public MessageHistory get() {
            return this.messageHistoryTL.get();
        }
    }
}

