/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.internal.Bootstrap;
import net.openhft.chronicle.core.internal.ClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    private static final String VALUE_FIELD_NAME = "value";
    private static final String COUNT_FIELD_NAME = "count";
    private static final String CODER_FIELD_NAME = "coder";
    private static final Field S_VALUE;
    private static final Field SB_COUNT;
    private static final Field S_CODER;
    private static final Field SB_CODER;
    private static final long S_VALUE_OFFSET;
    private static final long SB_VALUE_OFFSET;
    private static final long SB_COUNT_OFFSET;
    private static final long S_COUNT_OFFSET;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;

    private StringUtils() {
    }

    @NotNull
    private static UnsafeMemory getMemory() {
        return UnsafeMemory.INSTANCE;
    }

    public static boolean isEqual(@Nullable StringBuilder s, @Nullable CharSequence cs) {
        if (s == cs) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        int length = cs.length();
        if (s.length() != length) {
            return false;
        }
        return Bootstrap.isJava9Plus() ? StringUtils.isEqualJava9(s, cs, length) : StringUtils.isEqualJava8(s, cs, length);
    }

    public static void setLength(@NotNull StringBuilder sb, int length) {
        try {
            SB_COUNT.set(sb, length);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void set(@NotNull StringBuilder sb, CharSequence cs) {
        sb.setLength(0);
        sb.append(cs);
    }

    public static boolean endsWith(@NotNull CharSequence source, @NotNull String endsWith) {
        for (int i = 1; i <= endsWith.length(); ++i) {
            if (Character.toLowerCase(StringUtils.charAt(source, source.length() - i)) == Character.toLowerCase(endsWith.charAt(endsWith.length() - i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(@NotNull CharSequence source, @NotNull String startsWith) {
        for (int i = 0; i < startsWith.length(); ++i) {
            if (Character.toLowerCase(StringUtils.charAt(source, i)) == Character.toLowerCase(startsWith.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(@Nullable CharSequence s, @Nullable CharSequence cs) {
        int csLength;
        if (s instanceof StringBuilder) {
            return StringUtils.isEqual((StringBuilder)s, cs);
        }
        if (s == cs) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        int sLength = s.length();
        if (sLength != (csLength = cs.length())) {
            return false;
        }
        for (int i = 0; i < csLength; ++i) {
            if (StringUtils.charAt(s, i) == StringUtils.charAt(cs, i)) continue;
            return false;
        }
        return true;
    }

    private static char charAt(@NotNull CharSequence s, int i) {
        return s.charAt(i);
    }

    public static char[] extractChars(StringBuilder sb) {
        if (Bootstrap.isJava9Plus()) {
            char[] data = new char[sb.length()];
            sb.getChars(0, sb.length(), data, 0);
            return data;
        }
        return (char[])StringUtils.getMemory().getObject(sb, SB_VALUE_OFFSET);
    }

    private static boolean isEqualJava8(@NotNull StringBuilder s, @NotNull CharSequence cs, int length) {
        char[] chars = StringUtils.extractChars(s);
        for (int i = 0; i < length; ++i) {
            if (chars[i] == StringUtils.charAt(cs, i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualJava9(@NotNull StringBuilder s, @NotNull CharSequence cs, int length) {
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == StringUtils.charAt(cs, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsCaseIgnore(@Nullable CharSequence s, @NotNull CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Character.toLowerCase(StringUtils.charAt(s, i)) == Character.toLowerCase(StringUtils.charAt(cs, i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String toString(@Nullable Object o) {
        return o == null ? null : o.toString();
    }

    private static byte getStringCoderForStringOrStringBuilder(@NotNull CharSequence charSequence) {
        try {
            Field coder = charSequence instanceof String ? S_CODER : (charSequence instanceof StringBuilder ? SB_CODER : ClassUtil.getField0(charSequence.getClass(), CODER_FIELD_NAME, true));
            assert (coder != null);
            return coder.getByte(charSequence);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte getStringCoder(@NotNull String str) {
        return StringUtils.getStringCoderForStringOrStringBuilder(str);
    }

    public static byte getStringCoder(@NotNull StringBuilder str) {
        return StringUtils.getStringCoderForStringOrStringBuilder(str);
    }

    public static byte[] extractBytes(@NotNull StringBuilder sb) {
        StringUtils.ensureJava9Plus();
        return (byte[])StringUtils.getMemory().getObject(sb, SB_VALUE_OFFSET);
    }

    public static char[] extractChars(@NotNull String s) {
        if (Bootstrap.isJava9Plus()) {
            return s.toCharArray();
        }
        return (char[])StringUtils.getMemory().getObject(s, S_VALUE_OFFSET);
    }

    public static byte[] extractBytes(@NotNull String s) {
        StringUtils.ensureJava9Plus();
        return (byte[])StringUtils.getMemory().getObject(s, S_VALUE_OFFSET);
    }

    public static void setCount(@NotNull StringBuilder sb, int count) {
        StringUtils.getMemory().writeInt(sb, SB_COUNT_OFFSET, count);
    }

    @NotNull
    public static String newString(char @NotNull [] chars) {
        if (Bootstrap.isJava9Plus()) {
            return new String(chars);
        }
        @NotNull String str = new String();
        try {
            S_VALUE.set(str, chars);
            if (S_COUNT_OFFSET > -1L) {
                StringUtils.getMemory().writeInt(str, S_COUNT_OFFSET, chars.length);
            }
            return str;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void ensureJava9Plus() {
        if (!Bootstrap.isJava9Plus()) {
            throw new UnsupportedOperationException("This method is only supported on Java9+ runtimes");
        }
    }

    @NotNull
    public static String newStringFromBytes(byte @NotNull [] bytes) {
        StringUtils.ensureJava9Plus();
        @NotNull String str = new String();
        try {
            S_VALUE.set(str, bytes);
            return str;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public static String firstLowerCase(@Nullable String str) {
        char c2;
        if (str == null || str.isEmpty()) {
            return str;
        }
        char ch = str.charAt(0);
        return ch == (c2 = Character.toLowerCase(ch)) ? str : c2 + str.substring(1);
    }

    public static double parseDouble(@NotNull CharSequence in) {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        char ch = StringUtils.charAt(in, 0);
        int pos = 1;
        switch (ch) {
            case 'N': {
                if (StringUtils.compareRest(in, 1, "aN")) {
                    return Double.NaN;
                }
                return Double.NaN;
            }
            case 'I': {
                if (StringUtils.compareRest(in, 1, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            case '-': {
                if (StringUtils.compareRest(in, 1, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = StringUtils.charAt(in, pos++);
                break;
            }
        }
        while (true) {
            if (ch >= '0' && ch <= '9') {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != '.') break;
                decimalPlaces = 0;
            }
            if (pos == in.length()) break;
            ch = StringUtils.charAt(in, pos++);
        }
        if (decimalPlaces < 0) {
            decimalPlaces = 0;
        }
        return Maths.asDouble(value, exp, negative, decimalPlaces);
    }

    private static boolean compareRest(@NotNull CharSequence in, int pos, @NotNull String s) {
        if (s.length() > in.length() - pos) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtils.charAt(in, i + pos) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String toTitleCase(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        @NotNull StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(name.charAt(0)));
        boolean wasUnder = false;
        for (int i = 1; i < name.length(); ++i) {
            char ch1;
            char ch0 = name.charAt(i);
            char c = ch1 = i + 1 < name.length() ? (char)name.charAt(i + 1) : (char)' ';
            if (Character.isLowerCase(ch0)) {
                sb.append(Character.toUpperCase(ch0));
                if (Character.isUpperCase(ch1)) {
                    sb.append('_');
                    wasUnder = true;
                    continue;
                }
                wasUnder = false;
                continue;
            }
            if (Character.isUpperCase(ch0)) {
                if (!wasUnder && Character.isLowerCase(ch1)) {
                    sb.append('_');
                }
                sb.append(ch0);
                wasUnder = false;
                continue;
            }
            sb.append(ch0);
            wasUnder = ch0 == '_';
        }
        return sb.toString();
    }

    public static void reverse(StringBuilder text, int start) {
        int end = text.length() - 1;
        int mid = (start + end + 1) / 2;
        for (int i = 0; i < mid - start; ++i) {
            char ch = text.charAt(start + i);
            text.setCharAt(start + i, text.charAt(end - i));
            text.setCharAt(end - i, ch);
        }
    }

    public static int parseInt(CharSequence s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw StringUtils.forRadix(radix, true);
        }
        if (radix > 36) {
            throw StringUtils.forRadix(radix, false);
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = StringUtils.charAt(s, 0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw StringUtils.forInputString(s);
                }
                if (len == 1) {
                    throw StringUtils.forInputString(s);
                }
                ++i;
            }
            int multmin = limit / radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(StringUtils.charAt(s, i++), radix)) < 0) {
                    throw StringUtils.forInputString(s);
                }
                if (result < multmin) {
                    throw StringUtils.forInputString(s);
                }
                if ((result *= radix) < limit + digit) {
                    throw StringUtils.forInputString(s);
                }
                result -= digit;
            }
        } else {
            throw StringUtils.forInputString(s);
        }
        return negative ? result : -result;
    }

    static NumberFormatException forInputString(CharSequence s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    static NumberFormatException forRadix(int radix, boolean less) {
        if (less) {
            return new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        return new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
    }

    public static long parseLong(CharSequence s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw StringUtils.forRadix(radix, true);
        }
        if (radix > 36) {
            throw StringUtils.forRadix(radix, false);
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = StringUtils.charAt(s, 0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw StringUtils.forInputString(s);
                }
                if (len == 1) {
                    throw StringUtils.forInputString(s);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(StringUtils.charAt(s, i++), radix)) < 0) {
                    throw StringUtils.forInputString(s);
                }
                if (result < multmin) {
                    throw StringUtils.forInputString(s);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw StringUtils.forInputString(s);
                }
                result -= (long)digit;
            }
        } else {
            throw StringUtils.forInputString(s);
        }
        return negative ? result : -result;
    }

    static {
        try {
            S_VALUE = String.class.getDeclaredField(VALUE_FIELD_NAME);
            ClassUtil.setAccessible(S_VALUE);
            S_VALUE_OFFSET = StringUtils.getMemory().getFieldOffset(S_VALUE);
            if (Bootstrap.isJava9Plus()) {
                SB_CODER = ClassUtil.getField0(StringBuilder.class.getSuperclass(), CODER_FIELD_NAME, true);
                S_CODER = ClassUtil.getField0(String.class, CODER_FIELD_NAME, true);
            } else {
                S_CODER = null;
                SB_CODER = null;
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        long sCountOffset = -1L;
        try {
            Field sCount = String.class.getDeclaredField(COUNT_FIELD_NAME);
            ClassUtil.setAccessible(sCount);
            sCountOffset = StringUtils.getMemory().getFieldOffset(sCount);
        }
        catch (Exception sCount) {
            // empty catch block
        }
        S_COUNT_OFFSET = sCountOffset;
        try {
            SbFields sbFields = new SbFields();
            SB_COUNT = sbFields.sbCount;
            SB_VALUE_OFFSET = sbFields.sbValOffset;
            SB_COUNT_OFFSET = sbFields.sbCountOffset;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class SbFields {
        private Field sbValue;
        private long sbValOffset;
        private Field sbCount;
        private long sbCountOffset;

        public SbFields() throws ClassNotFoundException, NoSuchFieldException {
            try {
                this.sbValue = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField(StringUtils.VALUE_FIELD_NAME);
                ClassUtil.setAccessible(this.sbValue);
                this.sbValOffset = StringUtils.getMemory().getFieldOffset(this.sbValue);
                this.sbCount = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField(StringUtils.COUNT_FIELD_NAME);
                ClassUtil.setAccessible(this.sbCount);
                this.sbCountOffset = StringUtils.getMemory().getFieldOffset(this.sbCount);
            }
            catch (NoSuchFieldException e) {
                this.sbValue = Class.forName("java.lang.StringBuilder").getDeclaredField(StringUtils.VALUE_FIELD_NAME);
                ClassUtil.setAccessible(this.sbValue);
                this.sbValOffset = StringUtils.getMemory().getFieldOffset(this.sbValue);
                this.sbCount = Class.forName("java.lang.StringBuilder").getDeclaredField(StringUtils.COUNT_FIELD_NAME);
                ClassUtil.setAccessible(this.sbCount);
                this.sbCountOffset = StringUtils.getMemory().getFieldOffset(this.sbCount);
            }
        }
    }
}

