/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;

public abstract class AbstractBytesStore<B extends BytesStore<B, U>, U>
extends AbstractReferenceCounted
implements BytesStore<B, U> {
    private final byte[] internalNumberBuffer = new byte[20];

    protected AbstractBytesStore() {
    }

    protected AbstractBytesStore(boolean monitored) {
        super(monitored);
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) throws IllegalStateException {
        return offset < this.start() || this.readLimit() <= offset ? -1 : this.readUnsignedByte(offset);
    }

    public int hashCode() {
        return BytesStoreHash.hash32(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
    }

    @Override
    @NonNegative
    public long readPosition() {
        return 0L;
    }

    @Override
    public long readRemaining() {
        return this.readLimit() - this.readPosition();
    }

    @Override
    public long writeRemaining() {
        return this.writeLimit() - this.writePosition();
    }

    @Override
    @NonNegative
    public long start() {
        return 0L;
    }

    @Override
    protected boolean canReleaseInBackground() {
        return this.isDirectMemory();
    }

    @Override
    @Deprecated
    public byte[] internalNumberBuffer() {
        return this.internalNumberBuffer;
    }
}

