/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.SyncMode;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.channel.PipeHandler;
import net.openhft.chronicle.queue.channel.impl.PublishQueueChannel;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimingPauser;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.channel.AbstractHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;

public class PublishHandler
extends AbstractHandler<PublishHandler> {
    private String publish;
    private SyncMode syncMode;
    private int publishSourceId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFromChannelToQueue(ChronicleChannel channel, Pauser pauser, ChronicleQueue publishQueue, SyncMode syncMode) {
        try (ChronicleQueue publishQ = publishQueue;
             ExcerptAppender appender = publishQ.acquireAppender();){
            appender.singleThreadedCheckDisabled(true);
            boolean needsSync = false;
            while (!channel.isClosed()) {
                DocumentContext dc = channel.readingDocument();
                Throwable throwable = null;
                try {
                    pauser.unpause();
                    if (!dc.isPresent()) {
                        if (!needsSync) continue;
                        PublishHandler.syncAppender(appender, syncMode);
                        needsSync = false;
                        continue;
                    }
                    if (dc.isMetaData()) continue;
                    DocumentContext dc2 = appender.writingDocument();
                    Throwable throwable2 = null;
                    try {
                        dc.wire().copyTo((WireOut)dc2.wire());
                        needsSync = syncMode == SyncMode.SYNC || syncMode == SyncMode.ASYNC;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (dc2 == null) continue;
                        if (throwable2 != null) {
                            try {
                                dc2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        dc2.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
        }
        finally {
            Thread.currentThread().setName("connections");
        }
    }

    private static void syncAppender(ExcerptAppender appender, SyncMode syncMode) {
        if (syncMode == SyncMode.SYNC) {
            try (DocumentContext dc2 = appender.writingDocument();){
                dc2.wire().write((CharSequence)"sync").text("");
            }
        }
        appender.sync();
    }

    public String publish() {
        return this.publish;
    }

    public PublishHandler publish(String publish) {
        this.publish = publish;
        return this;
    }

    public SyncMode syncMode() {
        return this.syncMode;
    }

    public PublishHandler syncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
        return this;
    }

    public int publishSourceId() {
        return this.publishSourceId;
    }

    public PublishHandler publishSourceId(int publishSourceId) {
        this.publishSourceId = publishSourceId;
        return this;
    }

    public void run(ChronicleContext context, ChronicleChannel channel) {
        TimingPauser pauser = Pauser.balanced();
        Thread.currentThread().setName("publish~reader");
        try (AffinityLock lock = context.affinityLock();){
            PublishHandler.copyFromChannelToQueue(channel, (Pauser)pauser, PipeHandler.newQueue(context, this.publish, this.syncMode, this.publishSourceId), this.syncMode);
        }
    }

    public ChronicleChannel asInternalChannel(ChronicleContext context, ChronicleChannelCfg channelCfg) {
        return new PublishQueueChannel(channelCfg, this, PipeHandler.newQueue(context, this.publish, this.syncMode, this.publishSourceId));
    }
}

