/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.rollcycles.SparseRollCycles;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ChronicleQueueTwoThreadsTest
extends QueueTestCommon {
    private static final int BYTES_LENGTH = 256;
    private static final long INTERVAL_US = 10L;

    @Ignore(value="long running test")
    @Test(timeout=60000L)
    public void testUnbuffered() throws IOException, InterruptedException {
        this.doTest(false);
    }

    void doTest(boolean buffered) throws InterruptedException {
        int i;
        File name = this.getTmpDir();
        AtomicLong counter = new AtomicLong();
        Thread tailerThread = new Thread(() -> {
            AffinityLock rlock = AffinityLock.acquireLock();
            Bytes bytes = NativeBytes.nativeBytes((long)256L).unchecked(true);
            try (SingleChronicleQueue rqueue = SingleChronicleQueueBuilder.fieldlessBinary((File)name).testBlockSize().build();){
                ExcerptTailer tailer = rqueue.createTailer();
                while (!Thread.interrupted()) {
                    bytes.clear();
                    if (!tailer.readBytes(bytes)) continue;
                    counter.incrementAndGet();
                }
            }
            finally {
                if (rlock != null) {
                    rlock.release();
                }
            }
        }, "tailer thread");
        long runs = 50000L;
        Thread appenderThread = new Thread(() -> {
            AffinityLock wlock = AffinityLock.acquireLock();
            try {
                SingleChronicleQueue wqueue = SingleChronicleQueueBuilder.fieldlessBinary((File)name).rollCycle((RollCycle)SparseRollCycles.SMALL_DAILY).testBlockSize().writeBufferMode(buffered ? BufferMode.Asynchronous : BufferMode.None).build();
                ExcerptAppender appender = wqueue.acquireAppender();
                Bytes bytes = Bytes.allocateDirect((long)256L).unchecked(true);
                long next = System.nanoTime() + 10000L;
                int i = 0;
                while ((long)i < runs) {
                    while (System.nanoTime() < next) {
                    }
                    long start = next;
                    bytes.readPositionRemaining(0L, 256L);
                    bytes.writeLong(0L, start);
                    appender.writeBytes(bytes);
                    next += 10000L;
                    ++i;
                }
                wqueue.close();
            }
            finally {
                if (wlock != null) {
                    wlock.release();
                }
            }
        }, "appender thread");
        tailerThread.start();
        Jvm.pause((long)100L);
        appenderThread.start();
        appenderThread.join();
        for (i = 0; i < 10; ++i) {
            if (runs == counter.get()) continue;
            Jvm.pause((long)(Jvm.isDebug() ? 10000L : 100L));
        }
        for (i = 0; i < 10; ++i) {
            tailerThread.interrupt();
            tailerThread.join(100L);
        }
        Assert.assertEquals((long)runs, (long)counter.get());
    }
}

