/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventLoop;

public final class EventLoops {
    private EventLoops() {
    }

    public static void stopAll(Object ... eventLoops) {
        ArrayList<Callable<Void>> eventLoopStoppers = new ArrayList<Callable<Void>>();
        EventLoops.addAllEventLoopStoppers(Arrays.asList(eventLoops), eventLoopStoppers);
        for (Future<Void> voidFuture : ForkJoinPool.commonPool().invokeAll(eventLoopStoppers)) {
            try {
                voidFuture.get();
            }
            catch (ExecutionException e) {
                Jvm.error().on(EventLoops.class, "Error stopping event loop", e);
            }
            catch (InterruptedException e) {
                Jvm.warn().on(EventLoops.class, "Interrupted waiting for event loops to stop");
                Thread.currentThread().interrupt();
            }
        }
    }

    private static void addAllEventLoopStoppers(Collection<?> collection, List<Callable<Void>> stoppers) {
        for (Object o : collection) {
            if (o == null) continue;
            if (o instanceof EventLoop) {
                stoppers.add(() -> {
                    ((EventLoop)o).stop();
                    return null;
                });
                continue;
            }
            if (o instanceof Collection) {
                EventLoops.addAllEventLoopStoppers((Collection)o, stoppers);
                continue;
            }
            Jvm.warn().on(EventLoops.class, "Unexpected object passed to EventLoops.stop(): " + o);
        }
    }
}

