/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.threads;

import java.lang.ref.WeakReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.threads.Pauser;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class PauserMonitor
implements EventHandler {
    public static final boolean PERF_ENABLED = Jvm.isDebugEnabled(PauserMonitor.class);
    @NotNull
    private final WeakReference<Pauser> pauser;
    private final String description;
    private final int mills;
    private long nextLongTime = 0L;
    private long lastTime = 0L;
    private long lastTimePaused = 0L;
    private long lastCountPaused = 0L;

    public PauserMonitor(Pauser pauser, String description, int seconds) {
        this.pauser = new WeakReference<Pauser>(pauser);
        this.description = description;
        this.mills = seconds * 1000;
    }

    @Override
    public boolean action() throws InvalidEventHandlerException {
        long now = System.currentTimeMillis();
        if (this.nextLongTime > now) {
            return false;
        }
        Pauser pauserSnapshot = (Pauser)this.pauser.get();
        if (pauserSnapshot == null) {
            throw new InvalidEventHandlerException();
        }
        long timePaused = pauserSnapshot.timePaused();
        long countPaused = pauserSnapshot.countPaused();
        if (this.nextLongTime > 0L) {
            long timeDelta = now - this.lastTime;
            long timePausedDelta = timePaused - this.lastTimePaused;
            long countPausedDelta = countPaused - this.lastCountPaused;
            if (countPausedDelta > 0L) {
                double averageTime = (double)(timePausedDelta * 1000L / countPausedDelta) / 1000.0;
                double busy = Math.abs((double)((timeDelta - timePausedDelta) * 1000L / timeDelta) / 10.0);
                if (PERF_ENABLED) {
                    Jvm.perf().on(this.getClass(), this.description + ": avg pause: " + averageTime + " ms, count=" + countPausedDelta + (this.lastTime > 0L ? ", busy=" + busy + "%" : ""));
                }
            } else if (PERF_ENABLED) {
                Jvm.perf().on(this.getClass(), this.description + ": count=" + countPausedDelta + ", busy=100%");
            }
        }
        this.lastTimePaused = timePaused;
        this.lastCountPaused = countPaused;
        this.nextLongTime = now + (long)this.mills;
        this.lastTime = now;
        return true;
    }

    @Override
    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.MONITOR;
    }

    public String toString() {
        return "PauserMonitor<" + this.description + '>';
    }
}

