/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OnHeapBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.bytes.UncheckedNativeBytes;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.EmbeddedBytes;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.SingleThreaded;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SingleThreadedChecked;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SingleThreaded
public interface Bytes<U>
extends BytesStore<Bytes<U>, U>,
BytesIn<U>,
BytesOut<U>,
SingleThreadedChecked {
    public static final long MAX_CAPACITY = 0x7FFFFFFFFFFFFFF0L;
    public static final int MAX_HEAP_CAPACITY = 0x7FFFFFF0;
    public static final int DEFAULT_BYTE_BUFFER_CAPACITY = 256;

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer() {
        return Bytes.elasticByteBuffer(256);
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(@NonNegative int initialCapacity) {
        return Bytes.elasticByteBuffer(initialCapacity, 0x7FFFFFF0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> elasticByteBuffer(@NonNegative int initialCapacity, @NonNegative int maxCapacity) {
        Bytes<ByteBuffer> bytes;
        Longs.requireNonNegative(initialCapacity);
        Longs.requireNonNegative(maxCapacity);
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.elasticByteBuffer(initialCapacity, maxCapacity);
        try {
            bytes = bs.bytesForWrite();
        }
        catch (Throwable throwable) {
            try {
                bs.release(ReferenceOwner.INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(ReferenceOwner.INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer(@NonNegative int initialCapacity) {
        Longs.requireNonNegative(initialCapacity);
        @NotNull BytesStore<?, ByteBuffer> bs = BytesStore.wrap(ByteBuffer.allocate(initialCapacity));
        try {
            NativeBytes<ByteBuffer> nativeBytes = NativeBytes.wrapWithNativeBytes(bs, 0x7FFFFFF0L);
            return nativeBytes;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            bs.release(INIT);
        }
    }

    @NotNull
    public static Bytes<ByteBuffer> elasticHeapByteBuffer() {
        return Bytes.elasticHeapByteBuffer(128);
    }

    public static <T> Bytes<T> forFieldGroup(@NotNull T object, @NotNull String groupName) {
        ObjectUtils.requireNonNull(object);
        ObjectUtils.requireNonNull(groupName);
        @NotNull BytesStore<?, T> bs = BytesStore.forFields(object, groupName, 1);
        try {
            EmbeddedBytes bytes = EmbeddedBytes.wrap(bs);
            StreamingDataOutput streamingDataOutput = bytes.writeLimit(bs.writeLimit());
            return streamingDataOutput;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            bs.release(INIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForRead(@NotNull ByteBuffer byteBuffer) {
        Bytes<ByteBuffer> bytes;
        ObjectUtils.requireNonNull(byteBuffer);
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForRead();
            bbb.readLimit(byteBuffer.limit());
            bbb.readPosition(byteBuffer.position());
            bytes = bbb;
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException | BufferUnderflowException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Bytes<ByteBuffer> wrapForWrite(@NotNull ByteBuffer byteBuffer) {
        Bytes<ByteBuffer> bytes;
        ObjectUtils.requireNonNull(byteBuffer);
        BytesStore<?, ByteBuffer> bs = BytesStore.wrap(byteBuffer);
        try {
            Bytes<ByteBuffer> bbb = bs.bytesForWrite();
            bbb.writePosition(byteBuffer.position());
            bbb.writeLimit(byteBuffer.limit());
            bytes = bbb;
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException | BufferOverflowException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> wrapForRead(byte[] byteArray) {
        Bytes<byte[]> bytes;
        ObjectUtils.requireNonNull(byteArray);
        @NotNull BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            bytes = bs.bytesForRead();
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> wrapForWrite(byte[] byteArray) {
        Bytes<byte[]> bytes;
        ObjectUtils.requireNonNull(byteArray);
        BytesStore<?, byte[]> bs = BytesStore.wrap(byteArray);
        try {
            bytes = bs.bytesForWrite();
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull CharSequence text) {
        ObjectUtils.requireNonNull(text);
        return Bytes.from(text.toString());
    }

    public static Bytes<Void> fromDirect(@NotNull CharSequence text) {
        ObjectUtils.requireNonNull(text);
        return (Bytes)NativeBytes.nativeBytes(text.length()).append(text);
    }

    @NotNull
    public static Bytes<byte[]> directFrom(@NotNull String text) {
        Bytes<byte[]> bytes;
        BytesStore from = BytesStore.from(text);
        try {
            bytes = from.bytesForRead();
        }
        catch (Throwable throwable) {
            try {
                from.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        from.release(INIT);
        return bytes;
    }

    @NotNull
    public static Bytes<byte[]> from(@NotNull String text) {
        return Bytes.wrapForRead(text.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static Bytes<?> empty() {
        return BytesStore.empty().bytesForRead();
    }

    @UsedViaReflection
    public static Bytes<byte[]> valueOf(String text) {
        return Bytes.from(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VanillaBytes<Void> allocateDirect(@NonNegative long capacity) throws IllegalArgumentException {
        NativeBytes<Void> nativeBytes;
        @NotNull BytesStore<?, Void> bs = BytesStore.nativeStoreWithFixedCapacity(Longs.requireNonNegative(capacity));
        try {
            nativeBytes = new NativeBytes<Void>(bs);
        }
        catch (Throwable throwable) {
            try {
                bs.release(INIT);
                throw throwable;
            }
            catch (IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        bs.release(INIT);
        return nativeBytes;
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect() {
        return NativeBytes.nativeBytes();
    }

    @NotNull
    public static NativeBytes<Void> allocateElasticDirect(@NonNegative long initialCapacity) throws IllegalArgumentException {
        return NativeBytes.nativeBytes(Longs.requireNonNegative(initialCapacity));
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap() {
        return Bytes.allocateElasticOnHeap(32);
    }

    @NotNull
    public static OnHeapBytes allocateElasticOnHeap(@NonNegative int initialCapacity) {
        OnHeapBytes onHeapBytes;
        Longs.requireNonNegative(initialCapacity);
        BytesStore<?, byte[]> wrap = BytesStore.wrap(new byte[initialCapacity]);
        try {
            onHeapBytes = new OnHeapBytes(wrap, true);
        }
        catch (Throwable throwable) {
            try {
                wrap.release(INIT);
                throw throwable;
            }
            catch (IllegalArgumentException | IllegalStateException ise) {
                throw new AssertionError((Object)ise);
            }
        }
        wrap.release(INIT);
        return onHeapBytes;
    }

    @NotNull
    public static String toString(@NotNull Bytes<?> buffer) throws BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        return Bytes.toString(buffer, 0x7FFFFFF0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull Bytes<?> buffer, @NonNegative long maxLen) throws BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        Longs.requireNonNegative(maxLen);
        if (buffer.refCount() < 1) {
            return "<unknown>";
        }
        ReferenceOwner toString = ReferenceOwner.temporary("toString");
        buffer.reserve(toString);
        try {
            if (buffer.readRemaining() == 0L) {
                String string = "";
                return string;
            }
            long length = Math.min(maxLen + 1L, buffer.readRemaining());
            @NotNull StringBuilder builder = new StringBuilder();
            long readPosition = buffer.readPosition();
            try {
                buffer.readWithLength(length, (S b) -> {
                    while (buffer.readRemaining() > 0L) {
                        if ((long)builder.length() >= maxLen) {
                            builder.append("...");
                            break;
                        }
                        builder.append((char)buffer.readByte());
                    }
                });
            }
            catch (Exception e) {
                builder.append(' ').append(e);
            }
            finally {
                buffer.readPosition(readPosition);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            buffer.release(toString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull Bytes<?> buffer, @NonNegative long position, @NonNegative long length) {
        String string;
        ObjectUtils.requireNonNull(buffer);
        Longs.requireNonNegative(position);
        Longs.requireNonNegative(length);
        long pos = buffer.readPosition();
        long limit = buffer.readLimit();
        buffer.readPositionRemaining(position, length);
        try {
            @NotNull StringBuilder builder = new StringBuilder();
            while (buffer.readRemaining() > 0L) {
                builder.append((char)buffer.readByte());
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                buffer.readLimit(limit);
                buffer.readPosition(pos);
                throw throwable;
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        buffer.readLimit(limit);
        buffer.readPosition(pos);
        return string;
    }

    @NotNull
    public static VanillaBytes allocateDirect(byte[] bytes) throws IllegalArgumentException {
        VanillaBytes<Void> result = Bytes.allocateDirect(bytes.length);
        try {
            result.write(bytes);
        }
        catch (IllegalStateException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    @NotNull
    public static Bytes<?> fromHexString(@NotNull String s) {
        return BytesInternal.fromHexString(s);
    }

    @NotNull
    default public Bytes<U> unchecked(boolean unchecked) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        if (unchecked) {
            if (this.isElastic()) {
                BytesUtil.WarnUncheckedElasticBytes.warn();
            }
            UncheckedBytes underlyingBytes = this.start() == 0L && this.bytesStore().isDirectMemory() ? new UncheckedNativeBytes(this) : new UncheckedBytes(this);
            this.release(INIT);
            return underlyingBytes;
        }
        return this;
    }

    default public boolean unchecked() {
        return false;
    }

    @Override
    default public long safeLimit() {
        return this.bytesStore().safeLimit();
    }

    @Override
    default public boolean isClear() {
        return this.start() == this.readPosition() && this.writeLimit() == this.capacity();
    }

    @Override
    @NonNegative
    default public long realCapacity() {
        return BytesStore.super.realCapacity();
    }

    @Override
    public BytesStore<Bytes<U>, U> copy() throws IllegalStateException;

    @NotNull
    default public String toHexString() {
        return this.toHexString(1024L);
    }

    @NotNull
    default public String toHexString(@NonNegative long maxLength) {
        return this.toHexString(this.readPosition(), maxLength);
    }

    @NotNull
    default public String toHexString(@NonNegative long offset, @NonNegative long maxLength) {
        Longs.requireNonNegative(offset);
        Longs.requireNonNegative(maxLength);
        long maxLength2 = Math.min(maxLength, this.readLimit() - offset);
        String ret = BytesInternal.toHexString(this, offset, maxLength2);
        return maxLength2 < this.readLimit() - offset ? ret + "... truncated" : ret;
    }

    public boolean isElastic();

    @Override
    default public void ensureCapacity(@NonNegative long desiredCapacity) throws DecoratedBufferOverflowException, IllegalStateException {
        Longs.requireNonNegative(desiredCapacity);
        if (desiredCapacity > this.capacity()) {
            throw new DecoratedBufferOverflowException(this.isElastic() ? "todo" : "not elastic");
        }
    }

    @Override
    @NotNull
    default public Bytes<U> bytesForRead() throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        try {
            BytesStore bytesStore = this.bytesStore();
            if (!1.$assertionsDisabled && bytesStore == null) {
                throw new AssertionError((Object)"bytesStore is null");
            }
            return this.isClear() ? bytesStore.bytesForRead() : new SubBytes(bytesStore, this.readPosition(), this.readLimit() + this.start());
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    default public Bytes<U> bytesForWrite() throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        try {
            BytesStore bytesStore = this.bytesStore();
            if (!1.$assertionsDisabled && bytesStore == null) {
                throw new AssertionError((Object)"bytesStore is null");
            }
            return new VanillaBytes(bytesStore, this.writePosition(), this.writeLimit());
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nullable
    public BytesStore bytesStore();

    default public boolean isEqual(@Nullable String other) throws IllegalStateException {
        return StringUtils.isEqual(this, (CharSequence)other);
    }

    @NotNull
    public Bytes<U> compact() throws IllegalStateException;

    @Override
    default public long copyTo(@NotNull BytesStore targetByteStore) throws IllegalStateException {
        return BytesStore.super.copyTo(targetByteStore);
    }

    @Override
    default public void copyTo(@NotNull OutputStream outputStream) throws IOException, IllegalStateException {
        BytesStore.super.copyTo(outputStream);
    }

    @Override
    default public boolean sharedMemory() {
        return this.bytesStore().sharedMemory();
    }

    default public void unwrite(@NonNegative long fromOffset, @NonNegative int count) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        long wp = this.writePosition();
        if (wp < fromOffset) {
            return;
        }
        this.write(fromOffset, this, fromOffset + (long)count, wp - fromOffset - (long)count);
        this.writePosition(wp - (long)count);
    }

    default public long indexOf(@NotNull Bytes source) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        ReferenceCountedUtil.throwExceptionIfReleased(source);
        long sourceOffset = this.readPosition();
        long otherOffset = source.readPosition();
        long sourceCount = this.readRemaining();
        long otherCount = source.readRemaining();
        if (sourceCount <= 0L) {
            return Math.toIntExact(otherCount == 0L ? sourceCount : -1L);
        }
        if (otherCount == 0L) {
            return 0L;
        }
        try {
            byte firstByte = source.readByte(otherOffset);
            long max = sourceOffset + (sourceCount - otherCount);
            for (long i = sourceOffset; i <= max; ++i) {
                if (this.readByte(i) != firstByte) {
                    while (++i <= max && this.readByte(i) != firstByte) {
                    }
                }
                if (i > max) continue;
                long j = i + 1L;
                long end = j + otherCount - 1L;
                long k = otherOffset + 1L;
                while (j < end && this.readByte(j) == source.readByte(k)) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return Math.toIntExact(i - sourceOffset);
            }
            return -1L;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public int indexOf(@NotNull BytesStore source, @NonNegative int fromIndex) throws IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        ReferenceCountedUtil.throwExceptionIfReleased(source);
        long sourceOffset = this.readPosition();
        long otherOffset = source.readPosition();
        long sourceCount = this.readRemaining();
        long otherCount = source.readRemaining();
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if ((long)fromIndex >= sourceCount) {
            return Math.toIntExact(otherCount == 0L ? sourceCount : -1L);
        }
        if (otherCount == 0L) {
            return fromIndex;
        }
        try {
            byte firstByte = source.readByte(otherOffset);
            long max = sourceOffset + (sourceCount - otherCount);
            for (long i = sourceOffset + (long)fromIndex; i <= max; ++i) {
                if (this.readByte(i) != firstByte) {
                    while (++i <= max && this.readByte(i) != firstByte) {
                    }
                }
                if (i > max) continue;
                long j = i + 1L;
                long end = j + otherCount - 1L;
                long k = otherOffset + 1L;
                while (j < end && this.readByte(j) == source.readByte(k)) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return Math.toIntExact(i - sourceOffset);
            }
            return -1;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public Bytes<U> clear() throws IllegalStateException;

    @Override
    default public boolean readWrite() {
        return this.bytesStore().readWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void readWithLength(@NonNegative long length, @NotNull BytesOut<U> bytesOut) throws BufferUnderflowException, IORuntimeException, BufferOverflowException, IllegalStateException {
        Longs.requireNonNegative(length);
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(limit);
            bytesOut.write(this);
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
            this.lenient(lenient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T extends ReadBytesMarshallable> T readMarshallableLength16(@NotNull Class<T> clazz, @Nullable T using) throws BufferUnderflowException, IllegalStateException, InvalidMarshallableException {
        T object = using == null ? (ReadBytesMarshallable)ObjectUtils.newInstance(clazz) : using;
        int length = this.readUnsignedShort();
        long limit = this.readLimit();
        long end = this.readPosition() + (long)length;
        boolean lenient = this.lenient();
        try {
            this.lenient(true);
            this.readLimit(end);
            object.readMarshallable(this);
        }
        finally {
            this.readPosition(end);
            this.readLimit(limit);
            this.lenient(lenient);
        }
        return object;
    }

    @Override
    default public void writeMarshallableLength16(@NotNull WriteBytesMarshallable marshallable) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, InvalidMarshallableException {
        ObjectUtils.requireNonNull(marshallable);
        long position = this.writePosition();
        ValidatableUtil.validate(marshallable);
        try {
            this.writeUnsignedShort(0);
            marshallable.writeMarshallable(this);
            long length = this.lengthWritten(position) - 2L;
            if (length >= 65536L) {
                throw new IllegalStateException("Marshallable " + marshallable.getClass() + " too long was " + length);
            }
            this.writeUnsignedShort(position, (int)length);
        }
        catch (ArithmeticException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public Bytes write(@NotNull InputStream inputStream) throws IOException, BufferOverflowException, IllegalStateException {
        int read;
        ObjectUtils.requireNonNull(inputStream);
        while ((read = inputStream.read()) != -1) {
            this.writeByte((byte)read);
        }
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

