/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.SingleTableBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TableStoreTest
extends QueueTestCommon {
    @Test
    public void acquireValueFor() throws IOException {
        Throwable throwable;
        LongValue b2;
        Throwable throwable2;
        File file = DirectoryUtils.tempDir("table");
        file.mkdir();
        File tempFile = Files.createTempFile(file.toPath(), "table", ".cq4t", new FileAttribute[0]).toFile();
        try (TableStore table = SingleTableBuilder.binary((File)tempFile, (Metadata)Metadata.NoMeta.INSTANCE).build();){
            throwable2 = null;
            try (LongValue a = table.acquireValueFor((CharSequence)"a");){
                b2 = table.acquireValueFor((CharSequence)"b");
                throwable = null;
                try {
                    Assert.assertEquals((long)Long.MIN_VALUE, (long)a.getVolatileValue());
                    Assert.assertTrue((boolean)a.compareAndSwapValue(Long.MIN_VALUE, 1L));
                    Assert.assertEquals((long)Long.MIN_VALUE, (long)b2.getVolatileValue());
                    Assert.assertTrue((boolean)b2.compareAndSwapValue(Long.MIN_VALUE, 2L));
                    Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT\n}\n# position: 60, header: 0\n--- !!data #binary\na: 1\n# position: 80, header: 1\n--- !!data #binary\nb: 2\n...\n# 130972 bytes remaining\n", (Object)table.dump());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (b2 != null) {
                        if (throwable != null) {
                            try {
                                b2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            b2.close();
                        }
                    }
                }
            }
            catch (Throwable b2) {
                throwable2 = b2;
                throw b2;
            }
        }
        table = SingleTableBuilder.binary((File)tempFile, (Metadata)Metadata.NoMeta.INSTANCE).build();
        var4_4 = null;
        try {
            throwable2 = null;
            try (LongValue c = table.acquireValueFor((CharSequence)"c");){
                b2 = table.acquireValueFor((CharSequence)"b");
                throwable = null;
                try {
                    Assert.assertEquals((long)Long.MIN_VALUE, (long)c.getVolatileValue());
                    Assert.assertTrue((boolean)c.compareAndSwapValue(Long.MIN_VALUE, 3L));
                    Assert.assertEquals((long)2L, (long)b2.getVolatileValue());
                    Assert.assertTrue((boolean)b2.compareAndSwapValue(2L, 22L));
                    Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT\n}\n# position: 60, header: 0\n--- !!data #binary\na: 1\n# position: 80, header: 1\n--- !!data #binary\nb: 22\n# position: 96, header: 2\n--- !!data #binary\nc: 3\n...\n# 130956 bytes remaining\n", (Object)table.dump());
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (b2 != null) {
                        if (throwable != null) {
                            try {
                                b2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            b2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
        }
        catch (Throwable throwable8) {
            var4_4 = throwable8;
            throw throwable8;
        }
        finally {
            if (table != null) {
                if (var4_4 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable9) {
                        var4_4.addSuppressed(throwable9);
                    }
                } else {
                    table.close();
                }
            }
        }
    }

    @Test
    public void acquireValueForReadOnly() throws IOException {
        Throwable throwable;
        LongValue b;
        File file = DirectoryUtils.tempDir("table");
        file.mkdir();
        File tempFile = Files.createTempFile(file.toPath(), "table", ".cq4t", new FileAttribute[0]).toFile();
        try (TableStore table = SingleTableBuilder.binary((File)tempFile, (Metadata)Metadata.NoMeta.INSTANCE).build();){
            b = table.acquireValueFor((CharSequence)"b");
            throwable = null;
            try {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)b.getVolatileValue());
                Assert.assertTrue((boolean)b.compareAndSwapValue(Long.MIN_VALUE, 2L));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (b != null) {
                    if (throwable != null) {
                        try {
                            b.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        b.close();
                    }
                }
            }
        }
        table = SingleTableBuilder.binary((File)tempFile, (Metadata)Metadata.NoMeta.INSTANCE).readOnly(true).build();
        var4_4 = null;
        try {
            b = table.acquireValueFor((CharSequence)"b");
            throwable = null;
            try {
                Assert.assertEquals((long)2L, (long)b.getVolatileValue());
                Assert.assertThrows(IllegalStateException.class, () -> table.acquireValueFor((CharSequence)"d"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (b != null) {
                    if (throwable != null) {
                        try {
                            b.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        b.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (table != null) {
                if (var4_4 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable7) {
                        var4_4.addSuppressed(throwable7);
                    }
                } else {
                    table.close();
                }
            }
        }
    }
}

