/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.channel;

import java.io.File;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.queue.channel.DummyData;
import net.openhft.chronicle.queue.channel.Echoed;
import net.openhft.chronicle.queue.channel.Echoing;
import net.openhft.chronicle.queue.channel.EchoingMicroservice;
import net.openhft.chronicle.queue.channel.PipeHandler;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannel;
import net.openhft.chronicle.wire.channel.ChronicleChannelSupplier;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.ChronicleGatewayMain;

public class PerfLatencyMain
implements JLBHTask {
    static final int THROUGHPUT = Integer.getInteger("throughput", 50000);
    static final int ITERATIONS = Integer.getInteger("iterations", THROUGHPUT * 30);
    static final int SIZE = Integer.getInteger("size", 256);
    static final boolean BUFFERED = Jvm.getBoolean((String)"buffered");
    static final String URL = System.getProperty("url", "tcp://:1248");
    private static final PauserMode PAUSER_MODE = PauserMode.valueOf((String)System.getProperty("pauserMode", PauserMode.balanced.name()));
    private DummyData data;
    private Echoing echoing;
    private MethodReader reader;
    private Thread readerThread;
    private ChronicleChannel client;
    private ChronicleChannel server;
    private volatile boolean complete;
    private int sent;
    private volatile int count;
    private boolean warmedUp;
    private ChronicleContext context;

    public static void main(String[] args) {
        if (!URL.contains("//:")) {
            System.out.println("Make sure " + ChronicleGatewayMain.class + " is running first");
        }
        System.out.println("-Durl=" + URL + " -Dsize=" + SIZE + " -Dthroughput=" + THROUGHPUT + " -Diterations=" + ITERATIONS + " -DpauseMode=" + PAUSER_MODE + " -Dbuffered=" + BUFFERED);
        JLBHOptions lth = new JLBHOptions().warmUpIterations(50000).iterations(ITERATIONS).throughput(THROUGHPUT).acquireLock(AffinityLock::acquireLock).recordOSJitter(false).accountForCoordinatedOmission(false).runs(5).jlbhTask((JLBHTask)new PerfLatencyMain());
        new JLBH(lth).start();
    }

    public void init(JLBH jlbh) {
        this.data = new DummyData();
        this.data.data(new byte[SIZE - 8]);
        String path = new File("/dev/shm").isDirectory() ? "/dev/shm/echo" : OS.TMP + "/echo";
        IOTools.deleteDirWithFiles((String[])new String[]{path});
        new File(path).mkdir();
        this.context = ChronicleContext.newContext((String)URL);
        PipeHandler handler1 = (PipeHandler)new PipeHandler().subscribe(path + "/in").publish(path + "/out").buffered(Boolean.valueOf(BUFFERED));
        this.server = ((ChronicleChannelSupplier)((ChronicleChannelSupplier)this.context.newChannelSupplier((ChannelHandler)handler1).buffered(BUFFERED)).pauserMode(PAUSER_MODE)).get();
        Thread serverThread = new Thread(() -> this.runServer(this.server, Echoed.class, EchoingMicroservice::new), "server");
        serverThread.setDaemon(true);
        serverThread.start();
        PipeHandler handler2 = (PipeHandler)new PipeHandler().publish(path + "/in").subscribe(path + "/out").buffered(Boolean.valueOf(BUFFERED));
        this.client = ((ChronicleChannelSupplier)((ChronicleChannelSupplier)this.context.newChannelSupplier((ChannelHandler)handler2).buffered(BUFFERED)).pauserMode(PAUSER_MODE)).get();
        this.echoing = (Echoing)this.client.methodWriter(Echoing.class, new Class[0]);
        this.reader = this.client.methodReader(new Object[]{data -> {
            jlbh.sample(System.nanoTime() - data.timeNS());
            ++this.count;
        }});
        this.readerThread = new Thread(() -> {
            block15: {
                try (AffinityLock lock = AffinityLock.acquireLock();){
                    while (!Thread.currentThread().isInterrupted()) {
                        this.reader.readOne();
                    }
                }
                catch (Throwable t) {
                    if (this.complete) break block15;
                    t.printStackTrace();
                }
            }
        }, "last-reader");
        this.readerThread.setDaemon(true);
        this.readerThread.start();
    }

    private <OUT, MS> void runServer(ChronicleChannel server, Class<OUT> outClass, Function<OUT, MS> serviceConstructor) {
        Object out = server.methodWriter(outClass, new Class[0]);
        MS ms = serviceConstructor.apply(out);
        MethodReader reader = server.methodReader(new Object[]{ms});
        try (AffinityLock lock = AffinityLock.acquireLock();){
            while (!server.isClosed()) {
                reader.readOne();
            }
        }
        catch (ClosedIORuntimeException closed) {
            Jvm.warn().on(this.getClass(), closed.toString());
        }
    }

    public void warmedUp() {
        super.warmedUp();
        this.warmedUp = true;
    }

    public void run(long startTimeNS) {
        long lag;
        this.data.timeNS(startTimeNS);
        this.echoing.echo(this.data);
        if (!this.warmedUp && (lag = (long)(this.sent++ - this.count)) >= 50L) {
            LockSupport.parkNanos(lag * 500L);
        }
    }

    public void complete() {
        this.complete = true;
        this.readerThread.interrupt();
        this.client.close();
        this.server.close();
        this.context.close();
    }
}

