/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.File;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.table.UnlockMode;
import net.openhft.chronicle.threads.TimingPauser;

public abstract class AbstractTSQueueLock
extends AbstractCloseable
implements Closeable {
    protected static final String UNLOCK_MAIN_MSG = ". You can manually unlock with net.openhft.chronicle.queue.main.UnlockMain";
    protected static final String UNLOCKING_FORCIBLY_MSG = ". Unlocking forcibly. Note that this feature is designed to recover if another process died while holding a lock. If the other process is still alive, you may see queue corruption.";
    protected static final long PID = Jvm.getProcessId();
    public static final long UNLOCKED = Long.MIN_VALUE;
    protected final UnlockMode forceUnlockOnTimeoutWhen;
    protected final LongValue lock;
    protected final ThreadLocal<TimingPauser> pauser;
    protected final File path;
    protected final TableStore tableStore;
    private final String lockKey;

    public AbstractTSQueueLock(String lockKey, TableStore<?> tableStore, Supplier<TimingPauser> pauserSupplier) {
        this.tableStore = tableStore;
        this.lock = tableStore.doWithExclusiveLock(ts -> ts.acquireValueFor(lockKey));
        this.pauser = ThreadLocal.withInitial(pauserSupplier);
        this.path = tableStore.file();
        this.lockKey = lockKey;
        boolean dontRecoverLockTimeout = Jvm.getBoolean("queue.dont.recover.lock.timeout");
        if (dontRecoverLockTimeout) {
            this.forceUnlockOnTimeoutWhen = UnlockMode.NEVER;
            Jvm.warn().on(this.getClass(), "queue.dont.recover.lock.timeout property is deprecated and will be removed in a future version. Use queue.force.unlock.mode=NEVER instead");
        } else {
            this.forceUnlockOnTimeoutWhen = UnlockMode.valueOf(Jvm.getProperty("queue.force.unlock.mode", UnlockMode.LOCKING_PROCESS_DEAD.name()));
        }
        this.singleThreadedCheckDisabled(true);
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly((Object)this.lock);
    }

    protected void forceUnlock(long value) {
        boolean unlocked = this.lock.compareAndSwapValue(value, Long.MIN_VALUE);
        Jvm.warn().on(this.getClass(), "Forced unlock for the lock file:" + this.path + ", lockKey: " + this.lockKey + ", unlocked: " + unlocked, (Throwable)new StackTrace("Forced unlock"));
    }

    public boolean isLockedByCurrentProcess(LongConsumer notCurrentProcessConsumer) {
        long pid = this.lock.getVolatileValue();
        int realPid = (int)pid;
        if ((long)realPid == PID) {
            return true;
        }
        notCurrentProcessConsumer.accept(pid);
        return false;
    }

    public boolean forceUnlockIfProcessIsDead() {
        long pid;
        block3: {
            do {
                if ((pid = this.lock.getVolatileValue()) == Long.MIN_VALUE) {
                    return true;
                }
                int realPid = (int)pid;
                if (Jvm.isProcessAlive(realPid)) break block3;
                if (!Jvm.isDebugEnabled(this.getClass())) continue;
                Jvm.debug().on(this.getClass(), String.format("Forced unlocking `%s` in lock file:%s, as this was locked by: %d which is now dead", this.lockKey, this.path, realPid), (Throwable)new StackTrace("Forced unlock"));
            } while (!this.lock.compareAndSwapValue(pid, Long.MIN_VALUE));
            return true;
        }
        if (Jvm.isDebugEnabled(this.getClass())) {
            Jvm.debug().on(this.getClass(), String.format("Unable to release the lock=%s in the table store file=%s as it is being held by pid=%d, and this process is still running.", this.lockKey, this.path, pid));
        }
        return false;
    }

    public long lockedBy() {
        return this.lock.getVolatileValue();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{lock=" + this.lock + ", path=" + this.path + ", lockKey='" + this.lockKey + '\'' + '}';
    }
}

