/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.AbstractBytesStore;
import net.openhft.chronicle.bytes.internal.BytesFieldInfo;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.NoBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class HeapBytesStore<U>
extends AbstractBytesStore<HeapBytesStore<U>, U> {
    @Nullable
    private final Object realUnderlyingObject;
    private final int dataOffset;
    private final long capacity;
    @Nullable
    private final U underlyingObject;
    private UnsafeMemory memory = UnsafeMemory.MEMORY;

    private HeapBytesStore(@NotNull ByteBuffer byteBuffer) {
        super(false);
        this.underlyingObject = byteBuffer;
        this.realUnderlyingObject = byteBuffer.array();
        this.dataOffset = Jvm.arrayByteBaseOffset() + byteBuffer.arrayOffset();
        this.capacity = byteBuffer.capacity();
    }

    private HeapBytesStore(@Nullable byte[] byteArray) {
        super(false);
        this.underlyingObject = (U)byteArray;
        this.realUnderlyingObject = byteArray;
        this.dataOffset = Jvm.arrayByteBaseOffset();
        this.capacity = byteArray == null ? 0L : (long)byteArray.length;
    }

    private HeapBytesStore(Object object, long start, long length) {
        super(false);
        this.underlyingObject = object;
        this.realUnderlyingObject = object;
        this.dataOffset = Math.toIntExact(start);
        this.capacity = length;
    }

    public static <T> HeapBytesStore<T> forFields(Object o, String groupName, int padding) {
        BytesFieldInfo lookup = BytesFieldInfo.lookup(o.getClass());
        long start = lookup.startOf(groupName);
        long length = lookup.lengthOf(groupName);
        return new HeapBytesStore(o, start + (long)padding, length - (long)padding);
    }

    @NotNull
    public static HeapBytesStore<byte[]> wrap(byte[] byteArray) {
        if (byteArray == null) {
            throw new NullPointerException();
        }
        return new HeapBytesStore<byte[]>(byteArray);
    }

    @NotNull
    public static HeapBytesStore<ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return new HeapBytesStore<ByteBuffer>(bb);
    }

    long dataOffset() {
        return this.dataOffset;
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) throws BufferUnderflowException, ArithmeticException {
        if (from < 0L || to < 0L) {
            throw new IllegalArgumentException();
        }
        if (length < 0L || (long)((int)length) != length) {
            throw new IllegalArgumentException();
        }
        this.throwExceptionIfReleased();
        try {
            this.memory.copyMemory(this.realUnderlyingObject, (long)this.dataOffset + from, this.realUnderlyingObject, (long)this.dataOffset + to, (int)length);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return BytesInternal.toString(this);
    }

    @Override
    @NotNull
    public BytesStore<HeapBytesStore<U>, U> copy() {
        if (this.capacity == 0L) {
            return NoBytesStore.NO_BYTES_STORE;
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    protected void performRelease() {
        this.memory = null;
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.capacity;
    }

    @Override
    public U underlyingObject() {
        return this.underlyingObject;
    }

    Object realUnderlyingObject() {
        return this.realUnderlyingObject;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) {
        try {
            return this.memory.compareAndSwapInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) throws IllegalStateException {
        try {
            this.memory.testAndSetInt(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) {
        try {
            return this.memory.compareAndSwapLong(this.realUnderlyingObject, (long)this.dataOffset + offset, expected, value);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long read(@NonNegative long offsetInRDI, byte[] bytes, @NonNegative int offset, @NonNegative int length) {
        Longs.requireNonNegative(offsetInRDI);
        ObjectUtils.requireNonNull(bytes);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        try {
            int len = Maths.toUInt31(Math.min((long)length, Longs.requireNonNegative(this.readLimit() - offsetInRDI)));
            this.memory.copyMemory(this.realUnderlyingObject, (long)this.dataOffset + offsetInRDI, (Object)bytes, (long)(Unsafe.ARRAY_BYTE_BASE_OFFSET + offset), len);
            return len;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public byte readByte(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public short readShort(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public int readInt(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long readLong(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public float readFloat(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readFloat(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public double readDouble(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readDouble(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException {
        try {
            return this.memory.readVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException {
        try {
            this.throwExceptionIfReleased();
            return this.memory.readVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException {
        try {
            this.throwExceptionIfReleased();
            return this.memory.readVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset);
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore bs) {
        int i;
        ObjectUtils.requireNonNull(bs);
        int length0 = Math.toIntExact(bs.readRemaining());
        position = BytesUtil.writeStopBit(this, position, length0);
        for (i = 0; i < length0 - 7; i += 8) {
            this.writeLong(position + (long)i, bs.readLong(i));
        }
        while (i < length0) {
            this.writeByte(position + (long)i, bs.readByte(i));
            ++i;
        }
        return position + (long)length0;
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) {
        Longs.requireNonNegative(position);
        ObjectUtils.requireNonNull(s);
        Ints.requireNonNegative(start);
        Ints.requireNonNegative(length);
        try {
            this.throwExceptionIfReleased();
            position = BytesInternal.writeStopBit(this, position, length);
            this.memory.write8bit(s, start, this.realUnderlyingObject, (long)this.dataOffset + position, length);
            return position + (long)length;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeByte(@NonNegative long offset, byte b) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeByte(this.realUnderlyingObject, (long)this.dataOffset + offset, b);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeShort(@NonNegative long offset, short i16) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeInt(@NonNegative long offset, int i32) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeOrderedInt(@NonNegative long offset, int i32) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeOrderedInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeLong(@NonNegative long offset, long i64) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeOrderedLong(@NonNegative long offset, long i) throws BufferOverflowException {
        try {
            this.throwExceptionIfReleased();
            this.memory.writeOrderedLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeFloat(@NonNegative long offset, float f) throws BufferOverflowException {
        try {
            this.memory.writeFloat(this.realUnderlyingObject, (long)this.dataOffset + offset, f);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeDouble(@NonNegative long offset, double d) throws BufferOverflowException {
        try {
            this.memory.writeDouble(this.realUnderlyingObject, (long)this.dataOffset + offset, d);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeVolatileByte(@NonNegative long offset, byte i8) throws BufferOverflowException {
        try {
            this.memory.writeVolatileByte(this.realUnderlyingObject, (long)this.dataOffset + offset, i8);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeVolatileShort(@NonNegative long offset, short i16) throws BufferOverflowException {
        try {
            this.memory.writeVolatileShort(this.realUnderlyingObject, (long)this.dataOffset + offset, i16);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeVolatileInt(@NonNegative long offset, int i32) throws BufferOverflowException {
        try {
            this.memory.writeVolatileInt(this.realUnderlyingObject, (long)this.dataOffset + offset, i32);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> writeVolatileLong(@NonNegative long offset, long i64) throws BufferOverflowException {
        try {
            this.memory.writeVolatileLong(this.realUnderlyingObject, (long)this.dataOffset + offset, i64);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException {
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(byteArray);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        try {
            this.memory.copyMemory(byteArray, offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            return this;
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException {
        try {
            assert (this.realUnderlyingObject == null || this.dataOffset >= (Jvm.is64bit() ? 12 : 8));
            if (bytes.isDirect()) {
                this.memory.copyMemory(Jvm.address(bytes), this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            } else {
                this.memory.copyMemory(bytes.array(), offset, this.realUnderlyingObject, (long)this.dataOffset + offsetInRDO, length);
            }
        }
        catch (NullPointerException ifReleased) {
            this.throwExceptionIfReleased();
            throw ifReleased;
        }
    }

    @Override
    @NotNull
    public HeapBytesStore<U> write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfReleased();
        if (length == (long)((int)length)) {
            int i;
            int length0 = (int)length;
            for (i = 0; i < length0 - 7; i += 8) {
                long x = bytes.readLong(readOffset + (long)i);
                this.writeLong(writeOffset + (long)i, x);
            }
            while (i < length0) {
                byte x = bytes.readByte(readOffset + (long)i);
                this.writeByte(writeOffset + (long)i, x);
                ++i;
            }
        } else {
            this.writeLongLength(writeOffset, bytes, readOffset, length);
        }
        return this;
    }

    private void writeLongLength(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException {
        long i;
        ObjectUtils.requireNonNull(bytes);
        for (i = 0L; i < length - 7L; i += 8L) {
            long x = bytes.readLong(readOffset + i);
            this.writeLong(writeOffset + i, x);
        }
        while (i < length) {
            byte x = bytes.readByte(readOffset + i);
            this.writeByte(writeOffset + i, x);
            ++i;
        }
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws UnsupportedOperationException {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        if (offset >= this.capacity) {
            throw new BufferOverflowException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws UnsupportedOperationException {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        if (offset >= this.capacity) {
            throw new BufferOverflowException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeRead(@NonNegative long position, @NonNegative long address, @NonNegative long size) {
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (size + position > this.readLimit()) {
            throw new BufferOverflowException();
        }
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (size > 0L) {
            throw new UnsupportedOperationException("todo");
        }
    }

    @Override
    public void nativeWrite(@NonNegative long address, @NonNegative long position, @NonNegative long size) {
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (size + position > this.writeLimit()) {
            throw new BufferOverflowException();
        }
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        if (size > 0L) {
            throw new UnsupportedOperationException("todo");
        }
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

