/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Slf4jExceptionHandler implements ExceptionHandler
{
    ERROR{

        @Override
        public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
            logger.error(message, thrown);
        }
    }
    ,
    WARN{

        @Override
        public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
            logger.warn(message, thrown);
        }
    }
    ,
    PERF{

        @Override
        public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
            logger.info(message, thrown);
        }
    }
    ,
    DEBUG{

        @Override
        public void on(@NotNull Logger logger, @Nullable String message, Throwable thrown) {
            logger.debug(message, thrown);
        }

        @Override
        public boolean isEnabled(@NotNull Class<?> clazz) {
            return 4.getLogger(clazz).isDebugEnabled();
        }
    };

    static final ClassLocal<Logger> CLASS_LOGGER;

    static Logger getLogger(Class<?> clazz) {
        return (Logger)CLASS_LOGGER.get(clazz);
    }

    public static Slf4jExceptionHandler valueOf(LogLevel logLevel) {
        if (logLevel == LogLevel.ERROR) {
            return ERROR;
        }
        if (logLevel == LogLevel.WARN) {
            return WARN;
        }
        if (logLevel == LogLevel.PERF) {
            return PERF;
        }
        return DEBUG;
    }

    private static boolean isJUnitTest() {
        for (StackTraceElement[] stackTrace : Thread.getAllStackTraces().values()) {
            for (StackTraceElement element : stackTrace) {
                if (!element.getClassName().contains(".junit")) continue;
                return true;
            }
        }
        return false;
    }

    static {
        CLASS_LOGGER = ClassLocal.withInitial(LoggerFactory::getLogger);
    }
}

