/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMethodReader;
import net.openhft.chronicle.bytes.BytesParselet;
import net.openhft.chronicle.bytes.MethodEncoderLookup;
import net.openhft.chronicle.bytes.MethodReaderBuilder;
import net.openhft.chronicle.bytes.MethodReaderInterceptorReturns;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.IgnoresEverything;

public class BytesMethodReaderBuilder
implements MethodReaderBuilder {
    private final BytesIn<?> in;
    private BytesParselet defaultParselet;
    private MethodEncoderLookup methodEncoderLookup = MethodEncoderLookup.BY_ANNOTATION;
    private ExceptionHandler exceptionHandlerOnUnknownMethod = Jvm.debug();

    public BytesMethodReaderBuilder(BytesIn<?> in) {
        ReferenceCountedUtil.throwExceptionIfReleased(in);
        this.in = in;
    }

    @Override
    public MethodReaderBuilder exceptionHandlerOnUnknownMethod(ExceptionHandler exceptionHandler) {
        this.exceptionHandlerOnUnknownMethod = exceptionHandler;
        return this;
    }

    public MethodEncoderLookup methodEncoderLookup() {
        return this.methodEncoderLookup;
    }

    public BytesMethodReaderBuilder methodEncoderLookup(MethodEncoderLookup methodEncoderLookup) {
        this.methodEncoderLookup = methodEncoderLookup;
        return this;
    }

    public BytesParselet defaultParselet() {
        if (this.defaultParselet == null) {
            this.initDefaultParselet();
        }
        return this.defaultParselet;
    }

    private void initDefaultParselet() {
        this.defaultParselet = this.exceptionHandlerOnUnknownMethod instanceof IgnoresEverything ? Mocker.ignored(BytesParselet.class, new Class[0]) : (msg, in) -> {
            Bytes bytes = (Bytes)in;
            this.exceptionHandlerOnUnknownMethod.on(this.getClass(), "Unknown message type " + msg + " " + bytes.toHexString());
        };
    }

    public BytesMethodReaderBuilder defaultParselet(BytesParselet defaultParselet) {
        this.defaultParselet = defaultParselet;
        return this;
    }

    @Override
    public MethodReaderBuilder methodReaderInterceptorReturns(MethodReaderInterceptorReturns methodReaderInterceptorReturns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodReaderBuilder metaDataHandler(Object ... components) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesMethodReader build(Object ... objects) {
        return new BytesMethodReader(this.in, this.defaultParselet(), this.methodEncoderLookup, objects);
    }
}

