/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.ArrayBlockingQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ReadOneBackwardsTest
extends QueueTestCommon {
    @Test
    public void test() throws InterruptedException {
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(128);
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((File)this.getTmpDir()).sourceId(1).build();){
            MyDtoListener myOut = (MyDtoListener)q.methodWriter(MyDtoListener.class, new Class[0]);
            SnapshotListener snapshotOut = (SnapshotListener)q.methodWriter(SnapshotListener.class, new Class[0]);
            this.generateHistory(1);
            myOut.myDto(new MyDto());
            this.generateHistory(2);
            snapshotOut.snapshot(new SnapshotDTO("data"));
            this.generateHistory(3);
            myOut.myDto(new MyDto());
            this.generateHistory(4);
            myOut.myDto(new MyDto());
            ExcerptTailer tailer = q.createTailer().toEnd().direction(TailerDirection.BACKWARD);
            boolean success = tailer.methodReaderBuilder().warnMissing(false).build(new Object[]{new SnapshotListener(){

                @Override
                public void snapshot(SnapshotDTO e) {
                    blockingQueue.add(e);
                }
            }}).readOne();
            Assert.assertTrue((boolean)success);
            SnapshotDTO snapshotDTO = (SnapshotDTO)((Object)blockingQueue.poll());
            Assert.assertNotNull((Object)((Object)snapshotDTO));
            Assert.assertEquals((Object)"data", (Object)snapshotDTO.data);
        }
    }

    @NotNull
    private VanillaMessageHistory generateHistory(int value) {
        VanillaMessageHistory messageHistory = (VanillaMessageHistory)MessageHistory.get();
        messageHistory.reset();
        messageHistory.addSource(value, (long)value);
        return messageHistory;
    }

    static interface SnapshotListener {
        public void snapshot(SnapshotDTO var1);
    }

    static class SnapshotDTO
    extends SelfDescribingMarshallable {
        String data;

        public SnapshotDTO(String data) {
            this.data = data;
        }
    }

    static interface MyDtoListener {
        public void myDto(MyDto var1);
    }

    static class MyDto
    extends SelfDescribingMarshallable {
        String data;

        MyDto() {
        }
    }
}

