/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix.internal;

import jnr.ffi.Platform;
import net.openhft.posix.PosixAPI;
import net.openhft.posix.internal.jnr.JNRPosixAPI;
import net.openhft.posix.internal.jnr.WinJNRPosixAPI;
import net.openhft.posix.internal.noop.NoOpPosixAPI;
import org.slf4j.LoggerFactory;

public class PosixAPIHolder {
    public static PosixAPI POSIX_API;

    public static void loadPosixApi() {
        PosixAPI posixAPI;
        if (POSIX_API != null) {
            return;
        }
        try {
            posixAPI = Platform.getNativePlatform().isUnix() ? new JNRPosixAPI() : new WinJNRPosixAPI();
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(PosixAPIHolder.class).warn("Unable to load JNRPosixAPI", t);
            posixAPI = new NoOpPosixAPI();
        }
        POSIX_API = posixAPI;
    }

    public static void useNoOpPosixApi() {
        POSIX_API = new NoOpPosixAPI();
    }
}

