/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.stress;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.main.DumpMain;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class RollCycleMultiThreadStressTest
extends QueueTestCommon {
    final long SLEEP_PER_WRITE_NANOS;
    final int TEST_TIME;
    final int ROLL_EVERY_MS;
    final int DELAY_READER_RANDOM_MS;
    final int DELAY_WRITER_RANDOM_MS;
    final int CORES;
    final Random random;
    final int NUMBER_OF_INTS;
    final boolean PRETOUCH;
    final boolean READERS_READ_ONLY;
    final boolean DUMP_QUEUE;
    final boolean SHARED_WRITE_QUEUE;
    final boolean DOUBLE_BUFFER;
    final SetTimeProvider timeProvider = new SetTimeProvider();
    PretoucherThread pretoucherThread = null;
    private ChronicleQueue sharedWriterQueue;

    public RollCycleMultiThreadStressTest() {
        this(StressTestType.VANILLA);
    }

    protected RollCycleMultiThreadStressTest(StressTestType type) {
        this.SLEEP_PER_WRITE_NANOS = Long.getLong("writeLatency", 30000L);
        this.TEST_TIME = Integer.getInteger("testTime", 15);
        this.ROLL_EVERY_MS = Integer.getInteger("rollEvery", 300);
        this.DELAY_READER_RANDOM_MS = Integer.getInteger("delayReader", 1);
        this.DELAY_WRITER_RANDOM_MS = Integer.getInteger("delayWriter", 1);
        this.CORES = Integer.getInteger("cores", Runtime.getRuntime().availableProcessors());
        this.random = new Random(99L);
        this.NUMBER_OF_INTS = Integer.getInteger("numberInts", 18);
        boolean bl = this.PRETOUCH = type == StressTestType.PRETOUCH || type == StressTestType.PRETOUCH_EA;
        if (type == StressTestType.PRETOUCH_EA) {
            System.setProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle", "true");
        }
        this.READERS_READ_ONLY = type == StressTestType.READONLY;
        this.DUMP_QUEUE = false;
        this.SHARED_WRITE_QUEUE = type == StressTestType.SHAREDWRITEQ;
        boolean bl2 = this.DOUBLE_BUFFER = type == StressTestType.DOUBLEBUFFER;
        if (this.TEST_TIME > 15) {
            AbstractReferenceCounted.disableReferenceTracing();
            if (Jvm.isResourceTracing()) {
                throw new IllegalStateException("This test will run out of memory - change your system properties");
            }
        }
    }

    static boolean areAllReadersComplete(int expectedNumberOfMessages, List<Reader> readers) {
        boolean allReadersComplete = true;
        int count = 0;
        for (Reader reader : readers) {
            ++count;
            if (reader.lastRead >= expectedNumberOfMessages - 1) continue;
            allReadersComplete = false;
        }
        return allReadersComplete;
    }

    public static void main(String[] args) throws Exception {
        new RollCycleMultiThreadStressTest().stress();
    }

    static void shutdownAll(int waitSecs, ExecutorService ... ess) throws InterruptedException {
        for (ExecutorService es : ess) {
            es.shutdownNow();
        }
        for (ExecutorService es : ess) {
            if (es.awaitTermination(waitSecs, TimeUnit.MILLISECONDS)) continue;
            System.err.println(es + ": still running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void stress() throws Exception {
        long now;
        int i;
        this.ignoreException(" us to grow file");
        this.ignoreException("ms to check the disk space of");
        this.ignoreException("seconds to ASYNC");
        this.ignoreException("Running test with ");
        this.ignoreException("strict.discard.warning ");
        this.finishedNormally = false;
        assert (this.warnIfAssertsAreOn());
        File file = DirectoryUtils.tempDir("stress");
        int numThreads = this.CORES;
        int numWriters = numThreads / 4 + 1;
        int numReaders = numThreads - numWriters - 1;
        ExecutorService executorServicePretouch = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("pretouch"));
        ExecutorService executorServiceWrite = Executors.newFixedThreadPool(numWriters, (ThreadFactory)new NamedThreadFactory("writer"));
        ExecutorService executorServiceRead = Executors.newFixedThreadPool(numReaders, (ThreadFactory)new NamedThreadFactory("reader"));
        AtomicInteger wrote = new AtomicInteger();
        double expectedPerSecond = Jvm.isArm() ? 3.0E7 : (Jvm.isAzulZing() ? 3.0E8 : 1.0E9);
        int expectedNumberOfMessages = (int)((double)this.TEST_TIME * expectedPerSecond / (double)this.SLEEP_PER_WRITE_NANOS) * Math.max(1, numWriters / 2);
        Jvm.perf().on(this.getClass(), String.format("Running test with %d writers and %d readers (%d cores), sleep %dns expecting %d messages%n", numWriters, numReaders, this.CORES, this.SLEEP_PER_WRITE_NANOS, expectedNumberOfMessages));
        ArrayList<Future<Throwable>> results = new ArrayList<Future<Throwable>>();
        ArrayList<Reader> readers = new ArrayList<Reader>();
        ArrayList<Writer> writers = new ArrayList<Writer>();
        if (this.READERS_READ_ONLY) {
            ChronicleQueue ignored = this.createQueue(file);
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        if (this.SHARED_WRITE_QUEUE) {
            this.sharedWriterQueue = this.createQueue(file);
        }
        if (this.PRETOUCH) {
            this.pretoucherThread = new PretoucherThread(file);
            executorServicePretouch.submit(this.pretoucherThread);
            this.ignoreException("touchPage failed");
        }
        for (i = 0; i < numReaders; ++i) {
            Reader reader2 = new Reader(file, expectedNumberOfMessages, this.getReaderCheckingStrategy());
            readers.add(reader2);
            results.add(executorServiceRead.submit(reader2));
        }
        for (i = 0; i < numWriters; ++i) {
            Writer writer = new Writer(file, wrote, expectedNumberOfMessages);
            writers.add(writer);
            results.add(executorServiceWrite.submit(writer));
        }
        long maxWritingTime = TimeUnit.SECONDS.toMillis(this.TEST_TIME + (Jvm.isArm() ? 20 : 5)) + this.queueBuilder(file).timeoutMS();
        long startTime = System.currentTimeMillis();
        long giveUpWritingAt = startTime + maxWritingTime;
        long nextRollTime = System.currentTimeMillis() + (long)this.ROLL_EVERY_MS;
        long nextCheckTime = System.currentTimeMillis() + 5000L;
        while ((now = System.currentTimeMillis()) < giveUpWritingAt && wrote.get() < expectedNumberOfMessages) {
            if (now > nextRollTime) {
                this.timeProvider.advanceMillis(1000L);
                nextRollTime += (long)this.ROLL_EVERY_MS;
            }
            if (now > nextCheckTime) {
                String readersLastRead = readers.stream().map(reader -> Integer.toString(reader.lastRead)).collect(Collectors.joining(","));
                int w2 = wrote.get();
                Jvm.perf().on(this.getClass(), String.format("Writers have written %d of %d messages (%d%%) after %dms (%d%%) . Readers at %s. Waiting...", w2 + 1, expectedNumberOfMessages, (int)(100.0 * (double)(w2 + 1) / (double)expectedNumberOfMessages), now - startTime, (int)(100.0 * (double)(now - startTime) / (double)maxWritingTime), readersLastRead));
                readers.stream().filter(r -> !r.isMakingProgress()).findAny().ifPresent(reader -> {
                    if (reader.exception != null) {
                        throw new AssertionError("Reader encountered exception, so stopped reading messages", reader.exception);
                    }
                    throw new AssertionError((Object)"Reader is stuck");
                });
                if (this.pretoucherThread != null && this.pretoucherThread.exception != null) {
                    throw new AssertionError("Preloader encountered exception", this.pretoucherThread.exception);
                }
                nextCheckTime = System.currentTimeMillis() + 5000L;
            }
            Jvm.pause((long)5L);
        }
        long timeToWriteMillis = System.currentTimeMillis() - startTime;
        StringBuilder writerExceptions = new StringBuilder();
        writers.stream().filter(w -> w.exception != null).forEach(w -> writerExceptions.append("Writer failed due to: ").append(w.exception.getMessage()).append("\n"));
        Assert.assertTrue((String)("Wrote " + wrote.get() + " which is less than " + expectedNumberOfMessages + " within timeout. " + writerExceptions), (wrote.get() >= expectedNumberOfMessages ? 1 : 0) != 0);
        readers.stream().filter(r -> r.exception != null).findAny().ifPresent(reader -> {
            throw new AssertionError("Reader encountered exception, so stopped reading messages", reader.exception);
        });
        Jvm.perf().on(this.getClass(), String.format("Took %dms to write %d messages (max time allowed %dms)", timeToWriteMillis, expectedNumberOfMessages, maxWritingTime));
        long giveUpReadingAt = System.currentTimeMillis() + 20000L;
        long dumpThreadsAt = giveUpReadingAt - 5000L;
        try {
            while (System.currentTimeMillis() < giveUpReadingAt) {
                results.forEach(f -> {
                    try {
                        Throwable exception;
                        if (f.isDone() && (exception = (Throwable)f.get()) != null) {
                            throw Jvm.rethrow((Throwable)exception);
                        }
                    }
                    catch (InterruptedException exception) {
                    }
                    catch (ExecutionException e) {
                        throw Jvm.rethrow((Throwable)e);
                    }
                });
                boolean allReadersComplete = RollCycleMultiThreadStressTest.areAllReadersComplete(expectedNumberOfMessages, readers);
                if (allReadersComplete) break;
                Jvm.pause((long)2000L);
            }
            Assert.assertTrue((String)"Readers did not catch up", (boolean)RollCycleMultiThreadStressTest.areAllReadersComplete(expectedNumberOfMessages, readers));
        }
        catch (Throwable throwable) {
            System.clearProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle");
            Jvm.resetExceptionHandlers();
            RollCycleMultiThreadStressTest.shutdownAll(10, executorServicePretouch);
            RollCycleMultiThreadStressTest.shutdownAll(10, executorServiceWrite, executorServiceRead);
            Closeable.closeQuietly((Object)this.pretoucherThread);
            Closeable.closeQuietly((Object)this.sharedWriterQueue);
            results.forEach(f -> {
                try {
                    Throwable exception = (Throwable)f.get(100L, TimeUnit.MILLISECONDS);
                    if (exception != null) {
                        exception.printStackTrace();
                    }
                }
                catch (InterruptedException | TimeoutException exception) {
                }
                catch (ExecutionException e) {
                    throw Jvm.rethrow((Throwable)e);
                }
            });
            throw throwable;
        }
        System.clearProperty("SingleChronicleQueueExcerpts.earlyAcquireNextCycle");
        Jvm.resetExceptionHandlers();
        RollCycleMultiThreadStressTest.shutdownAll(10, executorServicePretouch);
        RollCycleMultiThreadStressTest.shutdownAll(10, executorServiceWrite, executorServiceRead);
        Closeable.closeQuietly((Object)this.pretoucherThread);
        Closeable.closeQuietly((Object)this.sharedWriterQueue);
        results.forEach(f -> {
            try {
                Throwable exception = (Throwable)f.get(100L, TimeUnit.MILLISECONDS);
                if (exception != null) {
                    exception.printStackTrace();
                }
            }
            catch (InterruptedException | TimeoutException exception) {
            }
            catch (ExecutionException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        });
        IOTools.deleteDirWithFiles((File)file);
        this.finishedNormally = true;
    }

    protected ReaderCheckingStrategy getReaderCheckingStrategy() {
        return new DefaultReaderCheckingStrategy();
    }

    private boolean warnIfAssertsAreOn() {
        String message = "Reminder: asserts are on";
        this.expectException("Reminder: asserts are on");
        Jvm.warn().on(this.getClass(), "Reminder: asserts are on");
        return true;
    }

    @NotNull
    SingleChronicleQueueBuilder queueBuilder(File path) {
        return SingleChronicleQueueBuilder.binary((File)path).testBlockSize().timeProvider((TimeProvider)this.timeProvider).doubleBuffer(this.DOUBLE_BUFFER).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY);
    }

    @NotNull
    private ChronicleQueue createQueue(File path) {
        return this.queueBuilder(path).build();
    }

    @NotNull
    private ChronicleQueue writerQueue(File path) {
        return this.sharedWriterQueue != null ? this.sharedWriterQueue : this.createQueue(path);
    }

    @Before
    public void multiCPU() {
        Assume.assumeTrue((Runtime.getRuntime().availableProcessors() > 1 ? 1 : 0) != 0);
    }

    static /* synthetic */ ChronicleQueue access$000(RollCycleMultiThreadStressTest x0, File x1) {
        return x0.writerQueue(x1);
    }

    static /* synthetic */ ChronicleQueue access$100(RollCycleMultiThreadStressTest x0) {
        return x0.sharedWriterQueue;
    }

    class PretoucherThread
    extends AbstractCloseable
    implements Callable<Throwable> {
        private final AtomicBoolean running;
        private final SingleChronicleQueue queue;
        volatile Throwable exception;

        PretoucherThread(File path) {
            this.queue = RollCycleMultiThreadStressTest.this.queueBuilder(path).build();
            this.running = new AtomicBoolean(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            try (ExcerptAppender appender = this.queue.acquireAppender();){
                while (this.running.get()) {
                    appender.pretouch();
                    Thread.sleep(5L);
                }
            }
            catch (Throwable e) {
                if (e instanceof ClosedIllegalStateException || this.queue.isClosed()) {
                    Throwable throwable = null;
                    return throwable;
                }
                this.exception = e;
                Throwable throwable = e;
                return throwable;
            }
            finally {
                Closeable.closeQuietly((Object)this.queue);
            }
            return null;
        }

        protected void performClose() {
            this.running.set(false);
        }
    }

    final class Writer
    implements Callable<Throwable> {
        final File path;
        final AtomicInteger wrote;
        final int expectedNumberOfMessages;
        volatile Throwable exception;

        Writer(File path, AtomicInteger wrote, int expectedNumberOfMessages) {
            this.path = path;
            this.wrote = wrote;
            this.expectedNumberOfMessages = expectedNumberOfMessages;
        }

        /*
         * Exception decompiling
         */
        @Override
        public Throwable call() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private int write(ExcerptAppender appender) {
            int value;
            try (DocumentContext writingDocument = appender.writingDocument();){
                long documentAcquireTimestamp = System.nanoTime();
                value = this.wrote.getAndIncrement();
                if (value >= this.expectedNumberOfMessages) {
                    writingDocument.rollbackOnClose();
                    int n = value;
                    return n;
                }
                ValueOut valueOut = writingDocument.wire().getValueOut();
                valueOut.int64(documentAcquireTimestamp);
                for (int i = 0; i < RollCycleMultiThreadStressTest.this.NUMBER_OF_INTS; ++i) {
                    valueOut.int32(value);
                }
                writingDocument.wire().padToCacheAlign();
            }
            return value;
        }
    }

    final class Reader
    implements Callable<Throwable> {
        final File path;
        final int expectedNumberOfMessages;
        final ReaderCheckingStrategy readerCheckingStrategy;
        volatile int lastRead = -1;
        volatile Throwable exception;
        int readSequenceAtLastProgressCheck = -1;

        Reader(File path, int expectedNumberOfMessages, ReaderCheckingStrategy readerCheckingStrategy) {
            this.path = path;
            this.expectedNumberOfMessages = expectedNumberOfMessages;
            this.readerCheckingStrategy = readerCheckingStrategy;
        }

        boolean isMakingProgress() {
            if (this.readSequenceAtLastProgressCheck == -1) {
                return true;
            }
            boolean makingProgress = this.lastRead > this.readSequenceAtLastProgressCheck;
            this.readSequenceAtLastProgressCheck = this.lastRead;
            return makingProgress;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Throwable call() {
            SingleChronicleQueueBuilder builder = RollCycleMultiThreadStressTest.this.queueBuilder(this.path);
            if (RollCycleMultiThreadStressTest.this.READERS_READ_ONLY) {
                builder.readOnly(true);
            }
            long last = System.currentTimeMillis();
            try (SingleChronicleQueue queue = builder.build();
                 ExcerptTailer tailer = queue.createTailer();){
                int lastTailerCycle = -1;
                int lastQueueCycle = -1;
                Jvm.pause((long)RollCycleMultiThreadStressTest.this.random.nextInt(RollCycleMultiThreadStressTest.this.DELAY_READER_RANDOM_MS));
                tailer.toStart();
                while (this.lastRead != this.expectedNumberOfMessages - 1) {
                    if (Thread.currentThread().isInterrupted()) {
                        Throwable throwable = null;
                        return throwable;
                    }
                    DocumentContext dc = tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!dc.isPresent()) {
                            long now = System.currentTimeMillis();
                            if (now <= last + 2000L) continue;
                            if (this.lastRead < 0) {
                                throw new AssertionError((Object)"read nothing after 2 seconds");
                            }
                            last = now;
                            continue;
                        }
                        ValueIn valueIn = dc.wire().getValueIn();
                        long documentAcquireTimestamp = valueIn.int64();
                        if (documentAcquireTimestamp == 0L) {
                            throw new AssertionError((Object)"No timestamp");
                        }
                        int expected = this.lastRead + 1;
                        this.readerCheckingStrategy.checkDocument(dc, tailer, (RollingChronicleQueue)queue, lastTailerCycle, lastQueueCycle, expected, valueIn);
                        this.lastRead = expected;
                        lastTailerCycle = tailer.cycle();
                        lastQueueCycle = queue.cycle();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                    }
                }
                this.readerCheckingStrategy.postReadCheck((RollingChronicleQueue)queue);
            }
            catch (Throwable e) {
                this.exception = e;
                Jvm.debug().on(this.getClass(), "Finished reader", e);
                return e;
            }
            Jvm.debug().on(this.getClass(), "Finished reader OK");
            return null;
        }
    }

    class DefaultReaderCheckingStrategy
    implements ReaderCheckingStrategy {
        DefaultReaderCheckingStrategy() {
        }

        @Override
        public void checkDocument(DocumentContext dc, ExcerptTailer tailer, RollingChronicleQueue queue, int lastTailerCycle, int lastQueueCycle, int expected, ValueIn valueIn) {
            for (int i = 0; i < RollCycleMultiThreadStressTest.this.NUMBER_OF_INTS; ++i) {
                int v = valueIn.int32();
                if (v == expected) continue;
                String failureMessage = "Expected: " + expected + ", actual: " + v + ", pos: " + i + ", index: " + Long.toHexString(dc.index()) + ", cycle: " + tailer.cycle();
                if (lastTailerCycle != -1) {
                    failureMessage = failureMessage + ". Tailer cycle at last read: " + lastTailerCycle + " (current: " + tailer.cycle() + "), queue cycle at last read: " + lastQueueCycle + " (current: " + queue.cycle() + ")";
                }
                if (RollCycleMultiThreadStressTest.this.DUMP_QUEUE) {
                    DumpMain.dump((File)queue.file(), (PrintStream)System.out, (long)Long.MAX_VALUE);
                }
                throw new AssertionError((Object)failureMessage);
            }
        }

        @Override
        public void postReadCheck(RollingChronicleQueue queue) {
        }
    }

    static interface ReaderCheckingStrategy {
        public void checkDocument(DocumentContext var1, ExcerptTailer var2, RollingChronicleQueue var3, int var4, int var5, int var6, ValueIn var7);

        public void postReadCheck(RollingChronicleQueue var1);
    }

    static enum StressTestType {
        VANILLA,
        READONLY,
        PRETOUCH,
        PRETOUCH_EA,
        DOUBLEBUFFER,
        SHAREDWRITEQ;

    }
}

