/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix.internal.jnr;

import java.io.IOException;
import java.util.function.IntSupplier;
import jnr.constants.platform.Errno;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.provider.FFIProvider;
import net.openhft.posix.Mapping;
import net.openhft.posix.MclFlag;
import net.openhft.posix.PosixAPI;
import net.openhft.posix.PosixRuntimeException;
import net.openhft.posix.ProcMaps;
import net.openhft.posix.internal.UnsafeMemory;
import net.openhft.posix.internal.core.Jvm;
import net.openhft.posix.internal.core.OS;
import net.openhft.posix.internal.jnr.JNRPosixInterface;
import net.openhft.posix.internal.jnr.LibraryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNRPosixAPI
implements PosixAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(JNRPosixAPI.class);
    static final Runtime RUNTIME = FFIProvider.getSystemProvider().getRuntime();
    static final Platform NATIVE_PLATFORM = Platform.getNativePlatform();
    static final String STANDARD_C_LIBRARY_NAME = NATIVE_PLATFORM.getStandardCLibraryName();
    static final Pointer NULL = Pointer.wrap(RUNTIME, 0L);
    static final int MLOCK_ONFAULT = 1;
    static final int SYS_mlock2 = Jvm.isArm() ? 390 : (Jvm.is64bit() ? 325 : 376);
    private final JNRPosixInterface jnr = LibraryUtil.load(JNRPosixInterface.class, STANDARD_C_LIBRARY_NAME);
    private final IntSupplier gettid = this.getGettid();
    private int get_nprocs_conf = 0;
    static final boolean MOCKALL_DUMP = Boolean.getBoolean("mlockall.dump");

    private IntSupplier getGettid() {
        try {
            this.jnr.gettid();
            return this.jnr::gettid;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (UnsafeMemory.IS32BIT) {
                return () -> this.jnr.syscall(224);
            }
            return () -> this.jnr.syscall(186);
        }
    }

    @Override
    public int open(CharSequence path, int flags, int perm) {
        return this.jnr.open(path, flags, perm);
    }

    @Override
    public long lseek(int fd, long offset, int whence) {
        return this.jnr.lseek(fd, offset, whence);
    }

    @Override
    public int ftruncate(int fd, long offset) {
        return this.jnr.ftruncate(fd, offset);
    }

    @Override
    public int lockf(int fd, int cmd, long len) {
        return this.jnr.lockf(fd, cmd, len);
    }

    @Override
    public int close(int fd) {
        return this.jnr.close(fd);
    }

    private static RuntimeException throwPosixException(String msg) {
        int lastError = RUNTIME.getLastError();
        for (Errno errno : Errno.values()) {
            if (errno.intValue() != lastError) continue;
            throw new PosixRuntimeException(msg + "error " + errno);
        }
        throw new PosixRuntimeException(msg + "unknown error " + lastError);
    }

    @Override
    public long mmap(long addr, long length, int prot, int flags, int fd, long offset) {
        Pointer wrap = addr == 0L ? NULL : Pointer.wrap(RUNTIME, addr);
        long mmap = this.jnr.mmap(wrap, length, prot, flags, fd, offset);
        if (mmap == 0L || mmap == -1L) {
            int lastError = RUNTIME.getLastError();
            for (Errno errno : Errno.values()) {
                if (errno.intValue() != lastError) continue;
                throw new PosixRuntimeException(errno.toString());
            }
        }
        return mmap;
    }

    private int mlock2_(long addr, long length, boolean lockOnFault) {
        if (!lockOnFault || OS.isMacOSX()) {
            return this.jnr.mlock(addr, length);
        }
        return this.jnr.syscall(SYS_mlock2, addr, length, 1);
    }

    @Override
    public boolean mlock(long addr, long length) {
        if (Jvm.isAzul()) {
            LOGGER.warn("mlock called but ignored for Azul");
            return true;
        }
        int err = this.jnr.mlock(addr, length);
        if (err == 0) {
            return true;
        }
        if (err == Errno.ENOMEM.intValue()) {
            return false;
        }
        throw JNRPosixAPI.throwPosixException("mlock length: " + length + " ");
    }

    @Override
    public boolean mlock2(long addr, long length, boolean lockOnFault) {
        if (Jvm.isAzul()) {
            LOGGER.warn("mlock2 called but ignored for Azul");
            return true;
        }
        int err = this.mlock2_(addr, length, lockOnFault);
        if (err == 0) {
            return true;
        }
        if (err == Errno.ENOMEM.intValue()) {
            return false;
        }
        throw JNRPosixAPI.throwPosixException("mlock2 length: " + length + " ");
    }

    @Override
    public void mlockall(int flags) {
        if (flags == MclFlag.MclCurrent.code() || flags == MclFlag.MclCurrentOnFault.code()) {
            this.tryMLockAll(flags);
            return;
        }
        int err = this.jnr.mlockall(flags);
        if (err == 0) {
            return;
        }
        throw JNRPosixAPI.throwPosixException("mlockall ");
    }

    private void tryMLockAll(int flags) {
        try {
            ProcMaps map = ProcMaps.forSelf();
            boolean onFault = flags == MclFlag.MclCurrentOnFault.code();
            for (Mapping mapping : map.list()) {
                if (mapping.perms().equals("---p")) continue;
                int ret = this.mlock2_(mapping.addr(), mapping.length(), onFault);
                if (!MOCKALL_DUMP) continue;
                long kb = mapping.length() / 1024L;
                if (ret != 0) {
                    int lastError = RUNTIME.getLastError();
                    for (Errno errno : Errno.values()) {
                        if (errno.intValue() != lastError) continue;
                        System.out.println(mapping + "len: " + kb + " KiB  " + errno);
                    }
                    continue;
                }
                System.out.println(mapping + "len: " + kb + " KiB " + (onFault ? " mlocked (on fault)" : " mlocked (current pages)"));
            }
        }
        catch (IOException ioe) {
            throw new PosixRuntimeException(ioe);
        }
    }

    @Override
    public int munmap(long addr, long length) {
        return this.jnr.munmap(addr, length);
    }

    @Override
    public int msync(long address, long length, int flags) {
        return this.jnr.msync(address, length, flags);
    }

    @Override
    public int fallocate(int fd, int mode, long offset, long length) {
        return UnsafeMemory.IS32BIT ? this.jnr.fallocate(fd, mode, offset, length) : this.jnr.fallocate64(fd, mode, offset, length);
    }

    @Override
    public int madvise(long addr, long length, int advice) {
        return this.jnr.madvise(addr, length, advice);
    }

    @Override
    public long read(int fd, long dst, long len) {
        return this.jnr.read(fd, dst, len);
    }

    @Override
    public long write(int fd, long src, long len) {
        return this.jnr.write(fd, src, len);
    }

    @Override
    public int gettimeofday(long timeval) {
        return this.jnr.gettimeofday(timeval, 0L);
    }

    @Override
    public long malloc(long size) {
        return this.jnr.malloc(size);
    }

    @Override
    public void free(long ptr) {
        this.jnr.free(ptr);
    }

    @Override
    public int get_nprocs() {
        return this.jnr.get_nprocs();
    }

    @Override
    public int get_nprocs_conf() {
        if (this.get_nprocs_conf == 0) {
            this.get_nprocs_conf = this.jnr.get_nprocs_conf();
        }
        return this.get_nprocs_conf;
    }

    @Override
    public int sched_setaffinity(int pid, int cpusetsize, long mask) {
        int ret = this.jnr.sched_setaffinity(pid, cpusetsize, Pointer.wrap(Runtime.getSystemRuntime(), mask));
        if (ret != 0) {
            throw new IllegalArgumentException(this.lastErrorStr() + ", ret: " + ret);
        }
        return ret;
    }

    @Override
    public int sched_getaffinity(int pid, int cpusetsize, long mask) {
        int ret = this.jnr.sched_getaffinity(pid, cpusetsize, Pointer.wrap(Runtime.getSystemRuntime(), mask));
        if (ret != 0) {
            throw new IllegalArgumentException(this.lastErrorStr() + ", ret: " + ret);
        }
        return ret;
    }

    @Override
    public int getpid() {
        return this.jnr.getpid();
    }

    @Override
    public int gettid() {
        int ret = this.gettid.getAsInt();
        if (ret < 0) {
            throw new IllegalArgumentException(this.lastErrorStr() + ", ret: " + ret);
        }
        return ret;
    }

    @Override
    public int lastError() {
        return Runtime.getSystemRuntime().getLastError();
    }

    @Override
    public String strerror(int errno) {
        return this.jnr.strerror(errno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long clock_gettime(int clockId) {
        long ptr = this.malloc(16L);
        try {
            int ret = this.jnr.clock_gettime(clockId, ptr);
            if (ret != 0) {
                throw new IllegalArgumentException(this.lastErrorStr() + ", ret: " + ret);
            }
            if (UnsafeMemory.IS32BIT) {
                long l = ((long)UnsafeMemory.UNSAFE.getInt(ptr) & 0xFFFFFFFFL) * 1000000000L + (long)UnsafeMemory.UNSAFE.getInt(ptr + 4L);
                return l;
            }
            long l = UnsafeMemory.UNSAFE.getLong(ptr) * 1000000000L + (long)UnsafeMemory.UNSAFE.getInt(ptr + 8L);
            return l;
        }
        finally {
            this.free(ptr);
        }
    }
}

