/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestEmptyFile {
    Path tmpDir = DirectoryUtils.tempDir(TestEmptyFile.class.getSimpleName()).toPath();

    @Before
    public void setup() throws IOException {
        this.tmpDir.toFile().mkdirs();
        File file = this.tmpDir.resolve("20170320.cq4").toFile();
        new FileOutputStream(file).close();
    }

    @After
    public void cleanup() {
        DirectoryUtils.deleteDir(this.tmpDir.toFile());
    }

    @Test
    public void shouldHandleEmptyFile() {
        Assume.assumeFalse((boolean)OS.isWindows());
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.tmpDir).testBlockSize().timeoutMS(100L).readOnly(true).build();){
            ExcerptTailer tailer = queue.createTailer();
            Assert.assertFalse((boolean)tailer.readingDocument().isPresent());
        }
    }
}

