/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.LogLevel;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.StoreAppender;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class NormaliseEOFsTest
extends QueueTestCommon {
    private static final String LOG_LEVEL_PROPERTY = "org.slf4j.simpleLogger.log." + StoreAppender.class.getName();
    private static final String QUEUE_PATH = "normaliseEOFsTest";
    private Map<ExceptionKey, Integer> exceptionMap;

    @Before
    public void setLogLevelProperty() {
        System.setProperty(LOG_LEVEL_PROPERTY, "debug");
    }

    @Before
    public void clearDataFromPreviousRun() {
        IOTools.deleteDirWithFilesOrThrow((String[])new String[]{QUEUE_PATH});
    }

    @Override
    @Before
    public void recordExceptions() {
        super.recordExceptions();
        this.exceptionMap = Jvm.recordExceptions((boolean)true);
        this.exceptionTracker = ExceptionTracker.create(ExceptionKey::message, ExceptionKey::throwable, Jvm::resetExceptionHandlers, this.exceptionMap, key -> key.level != LogLevel.DEBUG && key.level != LogLevel.PERF, key -> key.level() + " " + key.clazz().getSimpleName() + " " + key.message());
        this.ignoreException(ex -> true, "Ignore everything");
    }

    @After
    public void clearLogLevelProperty() {
        System.clearProperty(LOG_LEVEL_PROPERTY);
    }

    @Test
    public void normaliseShouldResumeFromPreviousNormalisation() {
        SetTimeProvider setTimeProvider = new SetTimeProvider();
        try (SingleChronicleQueue queue = this.createQueue((TimeProvider)setTimeProvider);
             ExcerptAppender excerptAppender = queue.acquireAppender();){
            for (int i = 0; i < 5; ++i) {
                this.createNewRollCycles(excerptAppender, setTimeProvider);
                excerptAppender.normaliseEOFs();
            }
            Pattern logPattern = Pattern.compile("Normalising from cycle (\\d+)");
            List startIndices = this.exceptionMap.keySet().stream().map(exceptionKey -> logPattern.matcher(exceptionKey.message)).filter(Matcher::matches).map(matcher -> Integer.parseInt(matcher.group(1))).collect(Collectors.toList());
            Assertions.assertTrue((startIndices.size() >= 5 ? 1 : 0) != 0);
            int lastStartIndex = Integer.MIN_VALUE;
            Iterator iterator = startIndices.iterator();
            while (iterator.hasNext()) {
                int startIndex = (Integer)iterator.next();
                Assertions.assertTrue((startIndex > lastStartIndex ? 1 : 0) != 0);
                lastStartIndex = startIndex;
            }
        }
    }

    private void createNewRollCycles(ExcerptAppender appender, SetTimeProvider timeProvider) {
        for (int i = 0; i < 10; ++i) {
            timeProvider.advanceMillis(3000L);
            try (DocumentContext documentContext = appender.writingDocument();){
                documentContext.wire().write((CharSequence)"aaa").text("bbb");
                continue;
            }
        }
    }

    private SingleChronicleQueue createQueue(TimeProvider setTimeProvider) {
        return SingleChronicleQueueBuilder.binary((String)QUEUE_PATH).timeProvider(setTimeProvider).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();
    }
}

