/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;
import org.junit.Test;

public class ChronicleRollingIssueTest
extends QueueTestCommon {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException {
        int threads = Math.min(64, Runtime.getRuntime().availableProcessors() * 4) - 1;
        int messages = 100;
        String path = OS.getTarget() + "/" + this.getClass().getSimpleName() + "-" + Time.uniqueId();
        AtomicInteger count = new AtomicInteger();
        StoreFileListener storeFileListener = (cycle, file) -> {};
        Runnable appendRunnable = () -> {
            try (SingleChronicleQueue writeQueue = ChronicleQueue.singleBuilder((String)path).testBlockSize().storeFileListener(storeFileListener).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
                for (int i = 0; i < messages; ++i) {
                    long millis = System.currentTimeMillis() % 100L;
                    if (millis > 1L && millis < 99L) {
                        Jvm.pause((long)(99L - millis));
                    }
                    ExcerptAppender appender = writeQueue.acquireAppender();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("key", Thread.currentThread().getName() + " - " + i);
                    appender.writeMap(map);
                    count.incrementAndGet();
                }
            }
        };
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < threads; ++i) {
            Thread thread = new Thread(appendRunnable, "appender-" + i);
            thread.start();
            threadList.add(thread);
        }
        long start = System.currentTimeMillis();
        long lastIndex = 0L;
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((String)path).testBlockSize().storeFileListener(storeFileListener).rollCycle((RollCycle)TestRollCycles.TEST_SECONDLY).build();){
            ExcerptTailer tailer = queue.createTailer();
            int count2 = 0;
            while (count2 < threads * messages) {
                Map map = tailer.readMap();
                long index = tailer.index();
                if (map != null) {
                    ++count2;
                } else if (index >= 0L && TestRollCycles.TEST_SECONDLY.toCycle(lastIndex) != TestRollCycles.TEST_SECONDLY.toCycle(index)) {
                    lastIndex = index;
                }
                if (System.currentTimeMillis() > start + 60000L) {
                    throw new AssertionError((Object)("Wrote: " + count + " read: " + count2 + " index: " + Long.toHexString(index)));
                }
            }
        }
        finally {
            for (Thread thread : threadList) {
                thread.interrupt();
                thread.join(1000L);
            }
            try {
                IOTools.deleteDirWithFiles((String)path, (int)2);
            }
            catch (IORuntimeException iORuntimeException) {}
        }
    }
}

