/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DocumentContextHolder;
import net.openhft.chronicle.wire.JSONWire;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MarshallableOutBuilder;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;

public class HTTPMarshallableOut
implements MarshallableOut {
    private final URL url;
    private final Wire wire;
    private final DocumentContextHolder dcHolder = new DocumentContextHolder(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            boolean chainedElement = this.chainedElement();
            super.close();
            if (chainedElement) {
                return;
            }
            if (HTTPMarshallableOut.this.wire.bytes().isEmpty()) {
                return;
            }
            try {
                HttpURLConnection conn = (HttpURLConnection)HTTPMarshallableOut.this.url.openConnection();
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestMethod("POST");
                try {
                    HTTPMarshallableOut.this.endWire();
                    try (OutputStream out = conn.getOutputStream();){
                        Bytes<?> bytes = HTTPMarshallableOut.this.wire.bytes();
                        byte[] b = (byte[])bytes.underlyingObject();
                        assert (b != null);
                        out.write(b, 0, (int)bytes.readLimit());
                    }
                    int responseCode = conn.getResponseCode();
                    if (responseCode < 200 || responseCode >= 300) {
                        throw new IORuntimeException("ResponseCode: " + responseCode);
                    }
                    Closeable.closeQuietly((Object)conn.getInputStream());
                    Closeable.closeQuietly((Object)conn.getErrorStream());
                }
                finally {
                    Closeable.closeQuietly((Object)conn);
                }
            }
            catch (IOException ioe) {
                throw new IORuntimeException(ioe);
            }
            HTTPMarshallableOut.this.startWire();
        }
    };

    public HTTPMarshallableOut(MarshallableOutBuilder builder, WireType wireType) {
        this.url = builder.url();
        this.wire = wireType == WireType.JSON ? ((TextWire)new JSONWire(Bytes.allocateElasticOnHeap()).useTypes(true).trimFirstCurly(true)).useTextDocuments() : (Wire)wireType.apply(Bytes.allocateElasticOnHeap());
        this.startWire();
    }

    void startWire() {
        this.wire.clear();
    }

    void endWire() {
        Bytes<?> bytes;
        if (!this.wire.isBinary() && (bytes = this.wire.bytes()).peekUnsignedByte(bytes.writePosition() - 1L) >= 32) {
            bytes.append('\n');
        }
    }

    @Override
    public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.dcHolder.documentContext(this.wire.writingDocument(metaData));
        return this.dcHolder;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) throws UnrecoverableTimeoutException {
        this.dcHolder.documentContext(this.wire.acquireWritingDocument(metaData));
        return this.dcHolder;
    }
}

